/*
 * @(#)BasicQueue.java	1.7 02/03/12
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging;

import javax.jms.*;

/**
 * A <code>BasicQueue</code> represents an identity of a repository of messages used
 * in the JMS Point-To-Point messaging domain.
 *
 * @version     1.7 02/03/12
 * @author      George Tharakan
 *
 * @see         javax.jms.Queue javax.jms.Queue
 */
public class BasicQueue extends com.sun.messaging.Destination implements javax.jms.Queue {

    /**
     * Constructs an identity of a Point-To-Point Queue with the default name
     */
    public BasicQueue () {
	super();
    }

    /**
     * Constructs an identity of a Point-To-Point Queue with the given name
     *
     * @param   name The name of the Queue
     */
    public BasicQueue (String name) throws javax.jms.JMSException {
	super(name);
    }

    /**
     * Compares this Queue to the specified object.
     * The result is <code>true</code> if and only if the arguement is not
     * <code>null</code> and is a <code>Queue</code> object with the same
     * Queue Name as this object.
     *
     * @param   anObject  The object to compare this <code>Queue</code> against.
     * @return  <code>true</code> if the object and this <code>Queue</code>are equal;
     *          <code>false</code> otherwise.
     *
     */
    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if ((anObject != null) && (anObject instanceof BasicQueue)) {
            try {
                //null test - since getQueueName could also return null
                String name = getQueueName();
                if (name != null) {
                    return name.equals(((BasicQueue)anObject).getQueueName());
                } else {
                    return (name == ((BasicQueue)anObject).getQueueName()) ;
                }
            } catch(JMSException e) {
                return false;
            }
        } else {
            return false;
        }
    }

    /**
     * Returns whether this is a Queueing type of Destination object
     *
     * @return whether this is a Queueing type of Destination object
     */
    public boolean isQueue() {
        return true;
    }

    /**
     * Returns whether this is a Temporary type of Destination object
     *
     * @return whether this is a Temporary type of Destination object
     */
    public boolean isTemporary() {
        return false;
    }
}
