/*
 * @(#)InvalidPropertyException.java	1.2 00/11/05
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging;

import javax.jms.JMSException;

/** 
 * An <code>InvalidPropertyException</code> is thrown when a setProperty
 * is called with an invalid property name parameter.
 * 
 * @version     1.2 00/11/05 
 * @author      George Tharakan 
 * 
 * @see         javax.jms.ConnectionFactory javax.jms.ConnectionFactory 
 * @see         com.sun.messaging.AdministeredObject#setProperty(String, String) com.sun.messaging.AdministeredObject.setProperty(propname, propval) 
 */

public class InvalidPropertyException extends javax.jms.JMSException {

    /**
     * Constructs an InvalidPropertyException.
     *   
     * @param property The invalid property name.
     */  
    public InvalidPropertyException(String property) {
        super(property);
    }

}

