/*
 * @(#)ClientConstants.java	1.3 03/03/23
 *
 * Copyright 2000-2001 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq;

/**
 * <code>ClientConstants</code> encapsulates JMQ specific
 * constant definitions and static strings used by the client that
 * need to be shared with the admin.
 *
 * @version     1.3 03/03/23
 */
public class ClientConstants {

    /* No public constructor needed */
    private ClientConstants(){}

    /** The connection type indicator for NORMAL connections */
    public static final String CONNECTIONTYPE_NORMAL = "NORMAL";
 
    /** The connection type indicator for ADMIN connections */
    public static final String CONNECTIONTYPE_ADMIN = "ADMIN";
 
    /** The connection type indicator for ADMINKEY connections */
    public static final String CONNECTIONTYPE_ADMINKEY = "ADMINKEY";
 
    /** The URI prefix for a temporary destination name */
    public static final String TEMPORARY_DESTINATION_URI_PREFIX = "temporary_destination://";

    /** The URI component for a temporary queue */
    public static final String TEMPORARY_QUEUE_URI_NAME = "queue/";

    /** The URI component for a temporary topic */
    public static final String TEMPORARY_TOPIC_URI_NAME = "topic/";

    /** The Destination Type value for an Unknown Destination */
    public static final int DESTINATION_TYPE_UNKNOWN = 0;

    /** The Destination Type value for a Queue Destination */
    public static final int DESTINATION_TYPE_QUEUE = 1;

    /** The Destination Type value for a Topic Destination */
    public static final int DESTINATION_TYPE_TOPIC = 2;

}
