/*
 * @(#)AStatusArea.java	1.3 00/11/27
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 */

package com.sun.messaging.jmq.admin.apps.console;

import java.awt.BorderLayout;
import javax.swing.BorderFactory;
import javax.swing.JTextArea;
import javax.swing.JScrollPane;
import javax.swing.JPanel;

/**
 * Admin Status Panel 
 *
 * @version     1.3 00/11/27
 * @author      Isa Hashim
 */
public class AStatusArea extends JPanel {

    private JTextArea statusTextArea;

    /**
     * Create status bar for admin console application.
     */
    public AStatusArea() {
	super(true);
	setLayout(new BorderLayout());
	statusTextArea = new JTextArea(4, 60);
	statusTextArea.setLineWrap(true);
	statusTextArea.setEditable(false);
	JScrollPane statusTextPane = new JScrollPane(statusTextArea);
	add(statusTextPane,  BorderLayout.CENTER);
    }
    
    /**
     * Append status text to the text area.
     *
     * @param statusText the status text
     */
    public void appendText(String statusText) {
	statusTextArea.append(statusText);
	statusTextArea.setCaretPosition(statusTextArea.getText().length());
    }

    /*
     * Clears the text shown in the Status Area.
     */
    public void clearText()  {
	statusTextArea.setText("");
    }
}
