/*
 * @(#)BrokerListCObj.java	1.17 05/02/10
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.admin.apps.console;

import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.JMenuItem;
import javax.swing.tree.DefaultMutableTreeNode;

import com.sun.messaging.jmq.admin.util.Globals;
import com.sun.messaging.jmq.admin.resources.AdminConsoleResources;

/** 
 * This class is used in the JMQ Administration console
 * to store information related to the list of brokers.
 *
 * @see ConsoleObj
 * @see BrokerAdminCObj
 *
 */
public class BrokerListCObj extends BrokerAdminCObj  {

    private ConsoleBrokerAdminManager baMgr = null;
    private static AdminConsoleResources acr = Globals.getAdminConsoleResources();

    private String label;

    public BrokerListCObj(ConsoleBrokerAdminManager baMgr)  {
        this.baMgr = baMgr;
	label = acr.getString(acr.I_BROKER_LIST); 
    }

    public ConsoleBrokerAdminManager getBrokerAdminManager() {
        return (baMgr);
    }

    public String getExplorerLabel()  {
	return (label);
    }

    public String getExplorerToolTip()  {
	return (null);
    }

    public ImageIcon getExplorerIcon()  {
	return (AGraphics.adminImages[AGraphics.BROKER_LIST]);
    }

    public String getActionLabel(int actionFlag, boolean forMenu)  {
	if (forMenu)  {
	    switch (actionFlag)  {
	    case ActionManager.ADD:
	        return (acr.getString(acr.I_MENU_ADD_BROKER));
	    }
	} else  {
	    switch (actionFlag)  {
	    case ActionManager.ADD:
	        return (acr.getString(acr.I_ADD_BROKER));
	    }
	}

	return (null);
    }

    public int getExplorerPopupMenuItemMask()  {
	return (getActiveActions());
    }


    public int getActiveActions()  {
	return (ActionManager.ADD);
    }


    public String getInspectorPanelClassName()  {
	return (ConsoleUtils.getPackageName(this) + ".BrokerListInspector");
    }

    public String getInspectorPanelId()  {
	return ("Broker List");
    }

    public String getInspectorPanelHeader()  {
	return (getInspectorPanelId());
    }
}
