/*
 * @(#)BrokerServiceListCObj.java	1.8 01/03/12
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.admin.apps.console;

import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.JMenuItem;

import com.sun.messaging.jmq.admin.bkrutil.BrokerAdmin;
import com.sun.messaging.jmq.admin.util.Globals;
import com.sun.messaging.jmq.admin.resources.AdminConsoleResources;

/** 
 * This class is used in the JMQ Administration console
 * to store information related to a broker's service
 * list.
 *
 * @see ConsoleObj
 * @see BrokerAdminCObj
 *
 */
public class BrokerServiceListCObj extends BrokerAdminCObj  {

    private BrokerCObj bCObj;
    private static AdminConsoleResources acr = Globals.getAdminConsoleResources();

    public BrokerServiceListCObj(BrokerCObj bCObj) {
        this.bCObj = bCObj;
    }

    public BrokerCObj getBrokerCObj() {
        return (bCObj);
    }

    public BrokerAdmin getBrokerAdmin() {
        return (bCObj.getBrokerAdmin());
    }

    public String getExplorerLabel()  {
	return (acr.getString(acr.I_BROKER_SVC_LIST));
    }

    public String getExplorerToolTip()  {
	return (null);
    }

    public ImageIcon getExplorerIcon()  {
	return (AGraphics.adminImages[AGraphics.BROKER_SERVICE_LIST]);
    }

    public int getExplorerPopupMenuItemMask()  {
	return (getActiveActions());
    }


    public int getActiveActions()  {
        BrokerAdmin ba = getBrokerAdmin();
        int mask;
        if (ba.isConnected())
            mask = ActionManager.REFRESH;
        else
            mask = 0;

        return (mask);
    }


    public String getInspectorPanelClassName()  {
	return (ConsoleUtils.getPackageName(this) + ".BrokerServiceListInspector");
    }

    public String getInspectorPanelId()  {
	return ("Services");
    }

    public String getInspectorPanelHeader()  {
	return (getInspectorPanelId());
    }
}
