/*
 * @(#)ObjStoreListCObj.java	1.17 05/02/10
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.admin.apps.console;

import javax.swing.ImageIcon;

import com.sun.messaging.jmq.admin.util.Globals;
import com.sun.messaging.jmq.admin.resources.AdminConsoleResources;
import com.sun.messaging.jmq.admin.objstore.ObjStoreManager;

/** 
 * This class is used in the JMQ Administration console
 * to store information related to the list of object stores.
 *
 * @see ConsoleObj
 * @see ObjStoreAdminCObj
 *
 */
public class ObjStoreListCObj extends ObjStoreAdminCObj  {
    private ObjStoreManager	osMgr = null;
    private static AdminConsoleResources acr = Globals.getAdminConsoleResources();
    private String label;

    /**
     * Create/initialize the admin explorer GUI component.
     */
    public ObjStoreListCObj(ObjStoreManager osMgr) {
	this.osMgr = osMgr;
	label = acr.getString(acr.I_OBJSTORE_LIST); 
    } 

    public ObjStoreManager getObjStoreManager()  {
	return (osMgr);
    }

    public String getExplorerLabel()  {
	return (label);
    }

    public String getExplorerToolTip()  {
	return (null);
    }

    public ImageIcon getExplorerIcon()  {
	return (AGraphics.adminImages[AGraphics.OBJSTORE_LIST]);
    }

    public String getActionLabel(int actionFlag, boolean forMenu)  {
	if (forMenu)  {
	    switch (actionFlag)  {
	    case ActionManager.ADD:
	        return (acr.getString(acr.I_MENU_ADD_OBJSTORE));
	    }
	} else  {
	    switch (actionFlag)  {
	    case ActionManager.ADD:
	        return (acr.getString(acr.I_ADD_OBJSTORE));
	    }
	}

	return (null);
    }

    public int getExplorerPopupMenuItemMask()  {
	return (getActiveActions());
    }


    public int getActiveActions()  {
	return (ActionManager.ADD);
    }


    public String getInspectorPanelClassName()  {
	return (ConsoleUtils.getPackageName(this) + ".ObjStoreListInspector");
    }

    public String getInspectorPanelId()  {
	return ("JMQ Object Stores");
    }

    public String getInspectorPanelHeader()  {
	return (getInspectorPanelId());
    }
}
