/*
 * @(#)ObjStoreListInspector.java	1.15 01/01/10
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.jmq.admin.objstore.ObjStore;
import com.sun.messaging.jmq.admin.util.Globals;
import com.sun.messaging.jmq.admin.resources.AdminConsoleResources;

/** 
 * Inspector panel for the list of object stores.
 *
 * @see InspectorPanel
 * @see AInspector
 * @see ConsoleObj
 */
public class ObjStoreListInspector extends TabledInspector {

    private static AdminConsoleResources acr = Globals.getAdminConsoleResources();

    /**
     * Return the array of Strings containing the collumn labels/headers.
     * @return the array of Strings containing the collumn labels/headers.
     */
    public String[] getColumnHeaders()  {
        String[] columnNames = {acr.getString(acr.I_OBJSTORE_NAME),
				acr.getString(acr.I_OBJSTORE_CONN_STATUS)};
	return (columnNames);
    }

    /**
     * Returns the Object at a particular cell collumn for a given
     * ConsoleObj object. Each row in the JTable represents one ConsoleObj.
     * This method returns the object/value for the ConsoleObj, for a particular 
     * collumn.
     *
     * @return the Object at a particular cell collumn for a given
     * ConsoleObj object.
     */
    public Object getValueAtCollumn(ConsoleObj conObj, int col)  {
	if (col == 0) {
	    return (conObj);
	} else if (col == 1) {
	    if (conObj instanceof ObjStoreCObj) {
	        ObjStore os = ((ObjStoreCObj)conObj).getObjStore();
		if (os.isOpen())
	    	    return acr.getString(acr.I_CONNECTED);
		else
	    	    return acr.getString(acr.I_DISCONNECTED);
	    }
	}

	return (null);
    }
}
