/*
 * @(#)AdminEvent.java	1.7 00/10/09
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 */

package com.sun.messaging.jmq.admin.apps.console.event;

import java.util.EventObject;

/**
 * Root class for all semantic events
 * within the admin console application.
 *
 * @version     1.7 00/10/09
 * @author      Isa Hashim
 */
public class AdminEvent extends EventObject {
    private int type = -1;

    /**
     * Creates an instance of AdminEvent
     * @param source the object where the event originated
     */
    public AdminEvent(Object source) {
	super(source);
    }

    /**
     * Creates an instance of AdminEvent
     * @param source the object where the event originated
     * @param type the event type
     */
    public AdminEvent(Object source, int type) {
	super(source);
	this.type = type;
    }

    /**
     * Returns the event type
     * @return the event type
     */
    public int getType()  {
	return type;
    }
}
