/*
 * @(#)BrokerErrorEvent.java	1.2 01/03/14
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 */

package com.sun.messaging.jmq.admin.apps.console.event;

import java.util.EventObject;

/**
 * Events related to reporting any kind of unexpected
 * errors and/or exceptions.
 */
public class BrokerErrorEvent extends AdminEvent {
    /*
     * Error type
     */
    public final static int	UNEXPECTED_SHUTDOWN	= 0;
    public final static int	ALT_SHUTDOWN		= 1;
    public final static int	CONNECTION_ERROR	= 2;

    private String brokerHost = null;
    private String brokerPort = null;
    private String brokerName = null;

    /**
     * Creates an instance of BrokerErrorEvent
     * @param source the object where the event originated
     */
    public BrokerErrorEvent(Object source, int type) {
	super(source, type);
    }

    public String getBrokerHost() {
	return brokerHost;
    }

    public void setBrokerHost(String host) {
	this.brokerHost = host;
    }

    public String getBrokerPort() {
	return brokerPort;
    }

    public void setBrokerPort(String port) {
	this.brokerPort = port;
    }

    public String getBrokerName() {
	return brokerName;
    }

    public void setBrokerName(String name) {
	this.brokerName = name;
    }
}
