/*
 * @(#)SelectionEvent.java	1.2 00/11/08
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 */

package com.sun.messaging.jmq.admin.apps.console.event;

import com.sun.messaging.jmq.admin.apps.console.ConsoleObj;

/**
 * Event for indicating something was either selected
 * or deselected. Can also be used to clear selection.
 *
 * @version     1.2 00/11/08
 * @author      Isa Hashim
 */
public class SelectionEvent extends AdminEvent {
    /*
     * Type of select event.
     */
    public final static int	OBJ_SELECTED	= 0;
    public final static int	OBJ_DESELECTED	= 1;
    public final static int	CLEAR_SELECTION	= 2;

    private ConsoleObj	selObj = null;

    /**
     * Creates an instance of SelectionEvent
     * @param source the object where the event originated
     */
    public SelectionEvent(Object source) {
	super(source);
    }

    /**
     * Creates an instance of SelectionEvent
     * @param source the object where the event originated
     * @id the event type
     */
    public SelectionEvent(Object source, int type) {
	super(source, type);
    }

    /**
     * Sets the selected object.
     * @param selectedObject The selected object.
     */
    public void setSelectedObj(ConsoleObj selectedObject)  {
	selObj = selectedObject;
    }
    /**
     * Returns the selected object.
     * @return The selected object.
     */
    public ConsoleObj getSelectedObj()  {
	return (selObj);
    }
}
