/*
 * @(#)BrokerAdminException.java	1.11 03/02/13
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.admin.bkrutil;

public class BrokerAdminException extends Exception {

    public static final int	CONNECT_ERROR		= 0;
    public static final int	MSG_SEND_ERROR		= 1;
    public static final int	MSG_REPLY_ERROR		= 2;
    public static final int	CLOSE_ERROR		= 3;
    public static final int	PROB_GETTING_MSG_TYPE	= 4;
    public static final int	PROB_GETTING_STATUS	= 5;
    public static final int	REPLY_NOT_RECEIVED	= 6;
    public static final int	INVALID_OPERATION	= 7;
    public static final int	INVALID_PORT_VALUE	= 8;
    public static final int	BAD_HOSTNAME_SPECIFIED	= 9;
    public static final int	BAD_PORT_SPECIFIED	= 10;
    public static final int	INVALID_LOGIN		= 11;
    public static final int	SECURITY_PROB		= 12;
    public static final int	BUSY_WAIT_FOR_REPLY	= 13;
    public static final int	IGNORE_REPLY_IF_RCVD	= 14;
    public static final int	PROB_SETTING_SSL	= 15;

    private BrokerAdmin	ba;
    private Exception	linkedException;
    private String	brokerErrorStr,
			badValue,
			brokerHost,
			brokerPort;
    private int		type,
			replyStatus,
    			replyMsgType;

    public BrokerAdminException(int type) {
	super();
	this.type = type;
    }

    public int getType()  {
	return (type);
    }

    public void setBrokerErrorStr(String errorStr)  {
	brokerErrorStr = errorStr;
    }
    public String getBrokerErrorStr()  {
	return (brokerErrorStr);
    }

    public void setReplyStatus(int replyStatus)  {
	this.replyStatus = replyStatus;
    }
    public int getReplyStatus()  {
	return (replyStatus);
    }

    public void setReplyMsgType(int replyMsgType)  {
	this.replyMsgType = replyMsgType;
    }
    public int getReplyMsgType()  {
	return (replyMsgType);
    }

    public void setBadValue(String badValue)  {
	this.badValue = badValue;
    }
    public String getBadValue()  {
	return (badValue);
    }

    public void setBrokerAdmin(BrokerAdmin ba)  {
	this.ba = ba;
    }
    public BrokerAdmin getBrokerAdmin()  {
	return (ba);
    }

    public void setLinkedException(Exception e)  {
	linkedException = e;
    }
    public Exception getLinkedException()  {
	return (linkedException);
    }

    public void setBrokerHost(String s)  {
	brokerHost = s;
    }
    public String getBrokerHost()  {
	return (brokerHost);
    }

    public void setBrokerPort(String s)  {
	brokerPort = s;
    }
    public String getBrokerPort()  {
	return (brokerPort);
    }
}
