/*
 * @(#)ObjStoreException.java	1.1 00/07/19
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.admin.objstore;

/**
 * <P>This is the root class of all ObjStore exceptions.
 *
 * <P>It provides following information:
 * <UL>
 *   <LI> A string describing the error - This string is 
 *        the standard Java exception message, and is available via 
 *        getMessage().
 *   <LI> A reference to another exception - Often a ObjStore exception will 
 *        be the result of a lower level problem. If appropriate, this 
 *        lower level exception can be linked to the ObjStore exception.
 * </UL>
 **/

public class ObjStoreException extends Exception {

    /**
     * Exception reference
     **/
    private Exception linkedException;

    /**
     * Constructs an ObjStoreException
     */ 
    public ObjStoreException() {
        super();
        linkedException = null;
    }

    /** 
     * Constructs an ObjStoreException with reason
     *
     * @param  reason        a description of the exception
     **/
    public ObjStoreException(String reason) {
        super(reason);
        linkedException = null;
    }

    /**
     * Gets the exception linked to this one
     *
     * @return the linked Exception, null if none
     **/
    public Exception getLinkedException() {
        return (linkedException);
    }

    /**
     * Adds a linked Exception
     *
     * @param ex       the linked Exception
     **/
    public synchronized void setLinkedException(Exception ex) {
        linkedException = ex;
    }
}
