/*
 * @(#)BasicAuthenticationHandler.java	1.8 05/11/09
 *
 * Copyright 2005 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */
package com.sun.messaging.jmq.auth.handlers;

import java.io.*;
import java.util.Hashtable;
import javax.security.auth.login.LoginException;
import com.sun.messaging.jmq.auth.api.client.*;
import com.sun.messaging.jmq.util.BASE64Encoder;

/**
 * MQ basic authentication request handler
 */

public class BasicAuthenticationHandler implements AuthenticationProtocolHandler {

    private String username = null;
    private String password = null;

    public String getType() {
        return "basic";
    }

    public void init(String username, String password,
                     Hashtable authProperties) throws LoginException {
        this.username = username;
        this.password = password;
    }

    public byte[] handleRequest(byte[] authRequest, int sequence) 
                                throws LoginException {
        if (username == null || password == null) {
            throw new LoginException("null");
        }

        try {

        byte[] response;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);

        dos.writeUTF(username); 

        BASE64Encoder encoder = new BASE64Encoder();
        String encodepass = encoder.encode(password.getBytes("UTF8"));
        dos.writeUTF(encodepass);
        dos.flush();
        response = bos.toByteArray();
        dos.close();
        return response;

        } catch (IOException e) {
        throw new LoginException("IOException: "+e.getMessage());  
        }
    }
}
