/*
 * @(#)PermissionFactory.java	1.2 05/11/17
 *
 * Copyright 2005 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */
package com.sun.messaging.jmq.auth.jaas;

import java.security.Permission;
import java.util.Map;

public interface PermissionFactory {

     public static final String DEST_RESOURCE_PREFIX = "mq-dest::";
     public static final String CONN_RESOURCE_PREFIX = "mq-conn::";
     public static final String AUTO_RESOURCE_PREFIX = "mq-auto::";

     public static final String CONN_NORMAL = "NORMAL";
     public static final String CONN_ADMIN = "ADMIN";

     public static final String DEST_QUEUE = "queue";
     public static final String DEST_TOPIC = "topic";

     public static final String DEST_QUEUE_PREFIX = "queue:";
     public static final String DEST_TOPIC_PREFIX = "topic:";
     public static final String ACTION_PRODUCE = "produce";
     public static final String ACTION_CONSUME = "consume";
     public static final String ACTION_BROWSE  = "browse";

    /**
     *
     * @param privateString A String private to a PermissionFactory 
     *                      implementation or null
     * @param resourceName The name of the protected resource to access
     * @param actions A comma separated list of allowable actions on 
     *                      the resource
     * @param conditions additional information (not used now)
     *
     * @return a java.security.Permission object
     *
     * @exception 
     *
     */
    public Permission newPermission(String privateString,
                                    String resourceName, 
                                    String actions,
                                    Map conditions);
}
