/*
 * @(#)MetricData.java	1.3 03/02/01
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.io;

import java.io.Serializable;
import com.sun.messaging.jmq.io.MetricCounters;

/**
 * This class represents metric performance data that is derived
 * from MetricCounters
 */

public class MetricData implements Serializable
{

    public MetricCounters   totals = null;
    public MetricCounters   rates  = null;

    public long     totalMemory;
    public long     freeMemory;

    public long     timestamp;

    public int      nConnections;

    public MetricData() {
        totals = new MetricCounters();
        rates  = new MetricCounters();
        reset();
    }

    /**
     * Reset counters to 0
     */
    public synchronized void reset() {

        totals.reset();
        rates.reset();

        timestamp = 0;
        totalMemory = 0;
        freeMemory = 0;
        nConnections = 0;
    }

    public synchronized void setTotals(MetricCounters counters) {
        totals.reset();
        totals.update(counters);
    }

    public synchronized void setRates(MetricCounters counters) {
        rates.reset();
        rates.update(counters);
    }

    public String toString() {
        String s =

        "Connections: " + nConnections + "    JVM Heap: " +
            totalMemory + " bytes (" + freeMemory + " free)" +
	" Threads: " + totals.threadsActive + " (" + totals.threadsLowWater + "-" + totals.threadsHighWater + ")" + "\n" +
        "      In: " +
        totals.messagesIn + " msgs (" + totals.messageBytesIn +  " bytes)  " +
         totals.packetsIn +  " pkts (" + totals.packetBytesIn  + " bytes)\n" +
        "     Out: " +
        totals.messagesOut + " msgs (" + totals.messageBytesOut +  " bytes)  " +
         totals.packetsOut +  " pkts (" + totals.packetBytesOut  + " bytes)\n" +
        " Rate In: " +
          rates.messagesIn + " msgs/sec (" + rates.messageBytesIn + " bytes/sec)  " +
           rates.packetsIn +  " pkts/sec (" + rates.packetBytesIn + " bytes/sec)\n" +
        "Rate Out: " +
         rates.messagesOut + " msgs/sec (" + rates.messageBytesOut + " bytes/sec)  " +
          rates.packetsOut +  " pkts/sec (" + rates.packetBytesOut + " bytes/sec)";

        return s;
    }
}
