/**
 * @(#)VRecord.java	1.10 12/18/03
 *
 * Copyright 2003 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.io;

import java.io.*;
import java.nio.*;
import java.nio.channels.*;
import java.util.*;

/**
 * A VRecord encapsulates a variable sized record backed by a file.
 */
public abstract class VRecord {

    // Info from record header.
    protected int magic = VRFile.RECORD_MAGIC_NUMBER;	// Record's magic number
    protected short state;     // Record's state
    protected int capacity;    // Record buffer's size including header
    protected short cookie = VRFile.RESERVED_SHORT; // application cookie

    /*
     * Force any modifications made to the buffer to be written
     * to physical storage.
     */
    public abstract void force() throws IOException;
    public abstract void setCookie(short cookie) throws IOException;
    public abstract short getCookie();

    /**
     * Return the capacity of this VRecord.
     */
    public int getCapacity() {
	return capacity;
    }

    /**
     * Return the capacity for data (ignoring header) of this VRecord.
     */
    public int getDataCapacity() {
	return capacity - VRFile.RECORD_HEADER_SIZE;
    }

    abstract void free();

    abstract void allocate(short state);

    short getState() {
	return state;
    }

}


