/*
 * @(#)JMSXATopicConnectionFactoryImpl.java	1.7 02/03/27
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.jmsclient;

import javax.jms.*;

import com.sun.jms.spi.xa.*;

import com.sun.messaging.ConnectionConfiguration;

/**
 * An <code>XATopicConnectionFactory</code> is used to create XATopicConnections with
 * a Java Message Service (JMS) Publish/Subscribe (Pub/Sub) provider.
 *
 * @version     1.7 02/03/27
 * @author      George Tharakan
 *
 * @see         javax.jms.XATopicConnectionFactory javax.jms.XATopicConnectionFactory
 */
public class JMSXATopicConnectionFactoryImpl extends com.sun.messaging.TopicConnectionFactory implements JMSXATopicConnectionFactory {

    /**
     * Constructs a JMSXATopicConnectionFactory with the default configuration.
     * 
     */
    public JMSXATopicConnectionFactoryImpl() {
        super("/com/sun/messaging/ConnectionFactory");
    }
 
    /**
     * Create an XA topic connection with default user identity.
     * The connection is created in stopped mode. No messages
     * will be delivered until <code>Connection.start</code> method
     * is explicitly called.
     *  
     * @return a newly created XA topic connection.
     *  
     * @exception JMSException if JMS Provider fails to create XA topic Connection
     *                         due to some internal error.
     * @exception JMSSecurityException  if client authentication fails due to
     *                         invalid user name or password.
     */ 

    public JMSXATopicConnection createXATopicConnection() throws JMSException {
        return createXATopicConnection(getProperty(ConnectionConfiguration.imqDefaultUsername),
                                        getProperty(ConnectionConfiguration.imqDefaultPassword));
    }

    /**
     * Create an XA topic connection with specified user identity.
     * The connection is created in stopped mode. No messages
     * will be delivered until <code>Connection.start</code> method
     * is explicitly called.
     *  
     * @param username the caller's user name
     * @param password the caller's password
     *  
     * @return a newly created XA topic connection.
     *  
     * @exception JMSException if JMS Provider fails to create XA topi connection
     *                         due to some internal error.
     * @exception JMSSecurityException  if client authentication fails due to
     *                         invalid user name or password.
     */ 
 
    public JMSXATopicConnection createXATopicConnection(String username,
                                                        String password) throws JMSException {
        return new JMSXATopicConnectionImpl(getCurrentConfiguration(), username, password, getConnectionType());
    }

}
