/*
 * @(#)MQAddress.java	1.7 03/21/05
 *
 * Copyright 2003 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.jmsclient;

import java.util.*;
import java.net.*;
import java.io.Serializable;

/**
 * This class represents broker address URL.
 */
public class MQAddress extends com.sun.messaging.jmq.io.MQAddress {

    protected static HashMap handlers = new HashMap();

    private static final String TCP_HANDLER =
        "com.sun.messaging.jmq.jmsclient.protocol.tcp.TCPStreamHandler";

    private static final String SSL_HANDLER =
        "com.sun.messaging.jmq.jmsclient.protocol.ssl.SSLStreamHandler";

    private static final String HTTP_HANDLER =
            "com.sun.messaging.jmq.jmsclient.protocol.http.HTTPStreamHandler";

    static {
        handlers.put("jms", TCP_HANDLER);
        handlers.put("ssljms", SSL_HANDLER);
        handlers.put("httpjms", HTTP_HANDLER);
        handlers.put("httpsjms", HTTP_HANDLER);
        handlers.put("admin", TCP_HANDLER);
        handlers.put("ssladmin", SSL_HANDLER);
        handlers.put("httpadmin", HTTP_HANDLER);
        handlers.put("httpsadmin", HTTP_HANDLER);
    }


    protected MQAddress() {
         super();
    }

    /**
     * Parses the given MQ Message Service Address and creates an
     * MQAddress object.
     */
    public static MQAddress 
           createMQAddress(String addr)
        throws MalformedURLException {
        MQAddress ret = new MQAddress();
        ret.initialize(addr);
        return ret;
    }




    public String getHandlerClass() {
        if (isHTTP)
            return HTTP_HANDLER;
        if (schemeName.equalsIgnoreCase("mqtcp"))
            return TCP_HANDLER;
        if (schemeName.equalsIgnoreCase("mqssl"))
            return SSL_HANDLER;

        String ret = (String) handlers.get(serviceName);
        // assert (ret != null);

        return ret;
    }


    public static void main(String args[]) throws Exception {
        MQAddress addr = createMQAddress(args[0]);
        System.out.println("schemeName = " + addr.getSchemeName());
        if (addr.getIsHTTP())
            System.out.println("URL = " + addr.getURL());
        else {
            System.out.println("host = " + addr.getHostName());
            System.out.println("port = " + addr.getPort());
        }
        System.out.println("serviceName = " + addr.getServiceName());
        System.out.println("handlerClass = " + addr.getHandlerClass());
        System.out.println("isFinal = " + addr.isServicePortFinal());
        System.out.println("properties = " + addr.props);
    }
}

/*
 * EOF
 */
