/*
 * @(#)MessageQueue.java	1.2 03/08/12
 *
 * Copyright 2003 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 */

package com.sun.messaging.jmq.jmsclient;

/**
 *
 * Interface to store and retrieve mq client messages in the memory.
 *
 * @author chiaming yang
 * @version 1.0
 */

public interface MessageQueue {

    /**
     * get the number of elements in the queue.
     * @return the number of elements in the queue.
     */
     public int size();

     /**
      * check if the queue size is empty.
      * @return true if the queue size is empty.
      */
     public boolean isEmpty();

    /**
     * Clears all elements stored in the queue
     **/
    public void clear ();

    /**
     * Enqueues the specified object in the queue.
     * @param nobj new object to be enqueued
     */
    public void enqueue(Object nobj);

    /**
     * Dequeues an element from the queue.
     * @return dequeued object, or null if empty queue
    */
    public Object dequeue();

    /**
     * Get all elements queue and return as an array
     * of objects.
     *
     * @return an array of objects in the queue.
     */
    public Object[] toArray();

    /**
     * Remove the specified obj from the queue.
     * @param obj the object to be removed in the queue.
     * @return if the specified object was removed.
     */
    public boolean remove (Object obj);
}
