/*
 * @(#)QueueConnectionImpl.java	1.20 05/02/08
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.jmsclient;

import javax.jms.*;
import java.util.Properties;

import com.sun.messaging.AdministeredObject;

/** A QueueConnection is an active connection to a JMS PTP provider. A
  * client uses a QueueConnection to create one or more QueueSessions
  * for producing and consuming messages.
  *
  * @version     1.20 05/02/08
  *
  * @see         javax.jms.Connection
  * @see	 javax.jms.QueueConnectionFactory
  */

public class QueueConnectionImpl extends UnifiedConnectionImpl implements com.sun.messaging.jms.QueueConnection {

    public
    QueueConnectionImpl(Properties configuration, String username,
                        String password, String type) throws JMSException {
        super(configuration, username, password, type);

        //bug 6172663
        setIsTopicConnection(false);
        super.setIsQueueConnection(true);
    }

    public QueueSession
    createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {

        return super.createQueueSession(transacted, acknowledgeMode);
    }

    public QueueSession
    createQueueSession(int acknowledgeMode) throws JMSException {

        checkConnectionState();

        //disallow to set client ID after this action.
        setClientIDFlag();

        return new QueueSessionImpl ( this, acknowledgeMode );
    }

    /**
    * Throws an IllegalStateException as it is an invalid method for this domain.
    *
    * @param topic the topic to access
    * @param subscriptionName durable subscription name
    * @param messageSelector only messages with properties matching the
    * message selector expression are delivered
    * @param sessionPool the serversession pool to associate with this
    * durable connection consumer.
    * @param maxMessages the maximum number of messages that can be
    * assigned to a server session at one time.
    *
    * @return the durable connection consumer.
    *
    * @exception IllegalStateException Always, since it is an invalid method for
    *            this domain.
    *
    * @see javax.jms.ConnectionConsumer
    */
    public ConnectionConsumer
    createDurableConnectionConsumer(Topic topic,
                                    String subscriptionName,
                                    String messageSelector,
                                    ServerSessionPool sessionPool,
                                    int maxMessages) throws JMSException {

        String errorString = AdministeredObject.cr.getKString(AdministeredObject.cr.X_ILLEGAL_METHOD_FOR_DOMAIN,
                                                              "createDurableConnectionConsumer");
        throw new javax.jms.IllegalStateException(errorString, AdministeredObject.cr.X_ILLEGAL_METHOD_FOR_DOMAIN);
    }
}
