/*
 * @(#)ReadQTable.java	1.5 03/12/19
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.jmsclient;

import java.util.Hashtable;
import java.util.Enumeration;
import java.util.Iterator;

class ReadQTable {

    Hashtable table = new Hashtable();

    // add new sessionQ
    protected void
    put (Object sessionId, Object sessionQ) {
        table.put(sessionId, sessionQ);
    }

    //remove sessionQ
    protected void
    remove (Object sessionId) {
        table.remove (sessionId);
    }

    protected SessionQueue
    get ( Object key ) {
        return (SessionQueue) table.get(key);
    }

    protected Enumeration
    elements() {
        return table.elements();
    }

    /**
     * Close all session queues in this read queue table.
     */
    protected void closeAll() {
        try {
            synchronized (table) {
                Iterator it = table.values().iterator();
                SessionQueue sq = null;

                while ( it.hasNext() ) {
                    sq = (SessionQueue) it.next();
                    sq.close();
                }
            }
        } catch (Exception e) {
            Debug.printStackTrace(e);
        }
    }

    /**
     * notify each queue in this table with a null pkt.
     */
    protected void notifyAllQueues() {
        try {
            synchronized (table) {
                Iterator it = table.values().iterator();
                SessionQueue sq = null;

                while ( it.hasNext() ) {
                    sq = (SessionQueue) it.next();
                    sq.enqueueNotify(null);
                }
            }
        } catch (Exception e) {
            Debug.printStackTrace(e);
        }
    }

}
