/*
 * @(#)TemporaryTopicImpl.java	1.12 02/04/24
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.jmsclient;

import javax.jms.*;
import com.sun.messaging.AdministeredObject;
import com.sun.messaging.jmq.ClientConstants;

/** A TemporaryTopic is a unique Topic object created for the duration of a
  * Connection. It is a system defined queue that can only be consumed
  * by the Connection that created it.
  *
  * @version     1.0 - 9 March 1998
  * @author      Mark Hapner
  * @author      Rich Burridge
  *
  * @see TopicSession#createTemporaryTopic()
  */
public class TemporaryTopicImpl extends TemporaryDestination implements TemporaryTopic {

    /**
     * Constructor used by createTemporaryTopic()
     */
    protected TemporaryTopicImpl (ConnectionImpl connection) throws JMSException {
        super(connection, ClientConstants.TEMPORARY_TOPIC_URI_NAME);
    }

    /**
     * Constructor used by MessageImpl.getJMSReplyTo()
     */
    protected TemporaryTopicImpl (String name) throws JMSException {
        super(name);
    }

    /**
     * Constructor used by MessageImpl.getJMSReplyTo()
     */
    protected TemporaryTopicImpl () throws JMSException {
        super();
    }

    public boolean isQueue() {
        return false;
    }

}
