/*
 * @(#)XAConnectionImpl.java	1.8 04/06/08
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.jmsclient;

import javax.jms.*;
import java.util.Properties;
import com.sun.messaging.jms.ra.ManagedConnection;

/** An XAConnection is an active connection to a JMS provider.
  * A client uses an XAConnection to create one or more XASessions
  * for producing and consuming messages.
  *
  * @version     1.8 04/06/08
  * @author      George Tharakan
  *
  * @see javax.jms.XAConnection
  * @see javax.jms.XAConnectionFactory
  */

public class XAConnectionImpl extends UnifiedConnectionImpl implements XAConnection {

    public
    XAConnectionImpl(Properties configuration, String username,
                    String password, String type) throws JMSException {
        super(configuration, username, password, type);
    }

    /**
     * Create an XASession.
     *  
     * @exception JMSException if JMS Connection fails to create an
     *                         XA session due to some internal error.
    public XASession
    createXASession() throws JMSException {

        checkConnectionState();
 
        //disallow to set client ID after this action.
        setClientIDFlag();
 
        return new XASessionImpl (this, false, 0);
    }
     */ 

    /**
     * Create an XASession
     *  
     * @param transacted
     * @param acknowledgeMode
     *  
     * @return a newly created XA topic session.
     *  
     * @exception JMSException if JMS Connection fails to create an
     *                         XA session due to some internal error.
     */ 
    public Session
    createSession(boolean transacted,
                       int acknowledgeMode) throws JMSException {

        checkConnectionState();
 
        //disallow to set client ID after this action.
        setClientIDFlag();
 
        return new XASessionImpl(this, transacted, acknowledgeMode);
    }

    public Session
    createSession(boolean transacted,
                       int acknowledgeMode, ManagedConnection mc) throws JMSException {

        checkConnectionState();
 
        //disallow to set client ID after this action.
        setClientIDFlag();
 
        return new XASessionImpl(this, transacted, acknowledgeMode, mc);
    }

    /**
     * Create an XAQueueSession
     *   
     * @param transacted      ignored.
     * @param acknowledgeMode ignored.
     *   
     * @return a newly created XA queue session.
     *   
     * @exception JMSException if JMS Connection fails to create a
     *                         XA queue session due to some internal error.
     */  
    public QueueSession
    createQueueSession(boolean transacted,
                       int acknowledgeMode) throws JMSException {

        checkConnectionState();
 
        //disallow to set client ID after this action.
        setClientIDFlag();
 
        return new XAQueueSessionImpl(this, transacted, acknowledgeMode);
    }

    public QueueSession
    createQueueSession(boolean transacted,
                       int acknowledgeMode, ManagedConnection mc) throws JMSException {

        checkConnectionState();
 
        //disallow to set client ID after this action.
        setClientIDFlag();
 
        return new XAQueueSessionImpl(this, transacted, acknowledgeMode, mc);
    }

    /**
     * Create an XATopicSession
     *   
     * @param transacted      ignored.
     * @param acknowledgeMode ignored.
     *   
     * @return a newly created XA topic session.
     *   
     * @exception JMSException if JMS Connection fails to create a
     *                         XA topic session due to some internal error.
     */  
    public TopicSession
    createTopicSession(boolean transacted,
                       int acknowledgeMode) throws JMSException {

        checkConnectionState();
 
        //disallow to set client ID after this action.
        setClientIDFlag();
 
        return new XATopicSessionImpl(this, transacted, acknowledgeMode);
    }

    public TopicSession
    createTopicSession(boolean transacted,
                       int acknowledgeMode, ManagedConnection mc) throws JMSException {

        checkConnectionState();
 
        //disallow to set client ID after this action.
        setClientIDFlag();
 
        return new XATopicSessionImpl(this, transacted, acknowledgeMode, mc);
    }


}
