/*
 * @(#)BrokerAddressListChangedEvent.java	1.1 05/07/28
 *
 * Copyright 2003 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */
package com.sun.messaging.jmq.jmsclient.notification;

import com.sun.messaging.jms.Connection;
import com.sun.messaging.jms.notification.ConnectionEvent;
import com.sun.messaging.jmq.jmsclient.resources.ClientResources;

/**
 * MQ Connection exit Event.
 *
 * <p>This event is used by MQ client runtime only.  This event is not
 * delivered to the application.
 *
 * <p>This event is generated by MQ client runtime and delivered to
 * the EventHandler.  When EventHandler receives this event, it calls the
 * Connection Exception Listener, and then closes the handler.
 *
 * @author chiaming yang
 * @version 4.0
 */
public class BrokerAddressListChangedEvent extends ConnectionEvent {

    private String addrList = null;

    /**
     *
     */
    public static final String CONNECTION_ADDRESS_LIST_CHANGED =
        ClientResources.E_CONNECTION_ADDRESS_LIST_CHANGED;

    /**
     * Construct a connection ADDRESS LIST CHANGED event.
     *
     * @param conn the connection that the event is associated with.
     *             MQ may automatically reconnect to the same broker
     *             or a different broker depends on the client runtime
     *             configuration.
     * @param evCode the event code that represents this event object.
     * @param evMessage the event message that describes this event object.
     * @param jmse the JMSException that caused this event.
     */
    public BrokerAddressListChangedEvent
        (Connection conn, String evCode, String evMessage, String addrList) {

        super (conn, evCode, evMessage);

        this.addrList = addrList;
    }

    public String getAddressList() {
        return this.addrList;
    }

}
