/*
 * @(#)ConnectionExitEvent.java	1.1 05/03/15
 *
 * Copyright 2003 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */
package com.sun.messaging.jmq.jmsclient.notification;

import com.sun.messaging.jms.notification.ConnectionEvent;
import com.sun.messaging.jms.Connection;

import javax.jms.JMSException;

/**
 * MQ Connection exit Event.
 *
 * <p>This event is used by MQ client runtime only.  This event is not
 * delivered to the application.
 *
 * <p>This event is generated by MQ client runtime and delivered to
 * the EventHandler.  When EventHandler receives this event, it calls the
 * Connection Exception Listener, and then closes the handler.
 *
 * @author chiaming yang
 * @version 4.0
 */
public class ConnectionExitEvent extends ConnectionEvent {

    // if there is any exception that caused the connection to be closed,
    //it is set to this event.
    private JMSException exception = null;

    /**
     *
     */
    public static final String CONNECTION_EXIT = "E500";

    /**
     * Construct a connection closed event.
     *
     * @param conn the connection that the event is associated with.
     *             MQ may automatically reconnect to the same broker
     *             or a different broker depends on the client runtime
     *             configuration.
     * @param evCode the event code that represents this event object.
     * @param evMessage the event message that describes this event object.
     * @param jmse the JMSException that caused this event.
     */
    public ConnectionExitEvent
        (Connection conn, String evCode, String evMessage, JMSException jmse) {

        super (conn, evCode, evMessage);

        this.exception = jmse;
    }

    /**
     * Get the JMSException that caused the connection to be closed.
     *
     * @return the JMSException that caused the connection to be closed.
     *         return null if no JMSException associated with this event.
     *         Such as connection closed caused by admin requested shutdown.
     */
    public JMSException getJMSException() {
        return exception;
    }

}
