
/*
 * @(#)TCPStreamHandler.java	1.11 05/03/21
 *
 * Copyright 2003 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */
package com.sun.messaging.jmq.jmsclient.protocol.tcp;

import java.io.*;
import javax.jms.JMSException;

import com.sun.messaging.PropertyOwner;
import com.sun.messaging.AdministeredObject;
import com.sun.messaging.ConnectionConfiguration;
import com.sun.messaging.jmq.jmsclient.*;


 /**
  * This class is the default protocol handler for the iMQ JMS client
  * implementation.  It uses TCP protocol to communicate with the Broker.
  */
public class TCPStreamHandler implements StreamHandler, PropertyOwner {

    /**
     * Null constructor for use by AdministeredObject when used as a PropertyOwner
     */  
    public TCPStreamHandler() {}

    public String[] getPropertyNames() {
        String [] propnames = new String [4];
        propnames[0] = ConnectionConfiguration.imqBrokerHostName;
        propnames[1] = ConnectionConfiguration.imqBrokerHostPort;
        propnames[2] = ConnectionConfiguration.imqBrokerServicePort;
        propnames[3] = ConnectionConfiguration.imqBrokerServiceName;
        return propnames;
    }

    public String getPropertyType(String propname) {
        if (ConnectionConfiguration.imqBrokerHostName.equals(propname) || 
                ConnectionConfiguration.imqBrokerServiceName.equals(propname)) { 
            return AdministeredObject.AO_PROPERTY_TYPE_STRING;
        } else {
            if (ConnectionConfiguration.imqBrokerHostPort.equals(propname) ||
                   ConnectionConfiguration.imqBrokerServicePort.equals(propname)) {
                return AdministeredObject.AO_PROPERTY_TYPE_INTEGER;
            }
        }
        return null;
    }

    public String getPropertyLabel(String propname) {
        if (ConnectionConfiguration.imqBrokerHostName.equals(propname)) {
            return (AdministeredObject.cr.L_JMQBROKER_HOST_NAME);
        } else {
            if (ConnectionConfiguration.imqBrokerHostPort.equals(propname)) {
                return (AdministeredObject.cr.L_JMQBROKER_HOST_PORT);
            } else {
                if (ConnectionConfiguration.imqBrokerServicePort.equals(propname)) {
                    return (AdministeredObject.cr.L_JMQBROKER_SERVICE_PORT);
                } else {
                    if (ConnectionConfiguration.imqBrokerServiceName.equals(propname)) {
                        return (AdministeredObject.cr.L_JMQBROKER_SERVICE_NAME);
                    }
                }
            }
        }
        return null;
    }
 
    public String getPropertyDefault(String propname) {
        if (ConnectionConfiguration.imqBrokerHostName.equals(propname)) {
            return "localhost";
        } else {
            if (ConnectionConfiguration.imqBrokerHostPort.equals(propname)) {
                return ("7676");
            } else {
                if (ConnectionConfiguration.imqBrokerServicePort.equals(propname)) {
                    return ("0");
                } else {
                    if (ConnectionConfiguration.imqBrokerServiceName.equals(propname)) {
                        return ("");
                    }
                }
            }
        }
        return null;
    }
 
    /**
     * Open socket a new connection.
     *
     * @param connection is the ConnectionImpl object.
     * @return a new instance of TCPConnectionHandler.
     * @exception throws IOException if socket creation failed.
     */
    public ConnectionHandler
    openConnection(Object connection) throws JMSException {
        return new TCPConnectionHandler(connection);
    }

    public ConnectionHandler openConnection(
        MQAddress addr, ConnectionImpl connection) throws JMSException {
        return new TCPConnectionHandler(addr, connection);
    }

}
