/*
 * @(#)AuthCacheData.java	1.2 05/11/09
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.jmsserver.auth;

import javax.security.auth.Refreshable;
import javax.security.auth.RefreshFailedException;

public class AuthCacheData 
{
    Refreshable cacheData = null;
    private boolean staled = true;

    public AuthCacheData() { }
    
    public synchronized void setCacheData(Refreshable data) {
        if (data == null) return;

        synchronized(data) {
            if (data.isCurrent()) {
                cacheData = data;
            }
        }
    }

    public synchronized Refreshable getCacheData() {
        return cacheData;
    }
   
    public synchronized void refresh() throws RefreshFailedException { 
        if (cacheData == null) return;

        synchronized(cacheData) {
            cacheData.refresh();
        }
    }
}
