/*
 * @(#)ClusterBroadcast.java	1.30 09/08/05
 *
 * Copyright 2003 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.core;

import java.io.IOException;
import java.util.Collection;
import java.util.Properties;
import java.util.Map;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.multibroker.Protocol;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.io.SysMessageID;

/**
 * Hides access to the clustering interface.
 */
public interface ClusterBroadcast {

    /** MessageBus protocol version */
    public static final int VERSION_400 = 400;
    public static final int VERSION_350 = 350;
    public static final int VERSION_300 = 300;
    public static final int VERSION_210 = 210;

    public static final int MSG_DELIVERED = 0;
    public static final int MSG_ACKNOWLEDGED = 1;
    public static final int MSG_TXN_ACKNOWLEDGED = 2;
    public static final int MSG_PREPARED = 3;
    public static final int MSG_ROLLEDBACK = 4;
    public static final int MSG_IGNORED = 5;
    public static final int MSG_UNDELIVERABLE = 6;
    public static final int MSG_DEAD = 7;


    public Protocol getProtocol();

    public boolean waitForConfigSync();
    public void setMatchProps(Properties match);

    public int getClusterVersion();

    public void startClusterIO();

    public void stopClusterIO(boolean requestTakeover);

    public void pauseMessageFlow() throws IOException;

    public void resumeMessageFlow() throws IOException;

    public void messageDelivered(SysMessageID id, ConsumerUID uid,
                BrokerAddress ba);

    public void forwardMessage(PacketReference ref, Collection consumers);

    /**
     * Returns the address of this broker.
     * @return <code> BrokerAddress </code> object representing this
     * broker.
     */
    public BrokerAddress getMyAddress();

    public boolean lockSharedResource(String resource, Object owner);

    public boolean lockDestination(DestinationUID uid, Object owner);

    public void unlockDestination(DestinationUID uid, Object owner);

    public boolean lockClientID(String clientid, Object owner, boolean shared);

    public void unlockClientID(String clientid, Object owner);

    public boolean getConsumerLock(ConsumerUID uid,
                    DestinationUID duid, int position,
                    int maxActive, Object owner)
            throws BrokerException;

    public void unlockConsumer(ConsumerUID uid, DestinationUID duid, int position);
    
    public void acknowledgeMessage(BrokerAddress address, SysMessageID mid, 
                                   ConsumerUID cid, int ackType, boolean ackack,
                                   Map optionalProps, Long txnID) 
                                   throws BrokerException;

    public void recordUpdateDestination(Destination d)
        throws BrokerException;

    public void recordRemoveDestination(Destination d)
        throws BrokerException;

    public void createDestination(Destination dest)
            throws BrokerException;

    public void recordCreateSubscription(Subscription sub)
        throws BrokerException;

    public void recordUnsubscribe(Subscription sub)
        throws BrokerException;

    public void createSubscription(Subscription sub, Consumer cons)
            throws BrokerException;

    public void createConsumer(Consumer con)
            throws BrokerException;

    public void updateDestination(Destination dest)
            throws BrokerException;

    public void updateSubscription(Subscription sub)
            throws BrokerException;

    public void updateConsumer(Consumer con)
            throws BrokerException;


    public void destroyDestination(Destination dest)
            throws BrokerException;

    public void destroySubscription(Subscription sub)
            throws BrokerException;

    public void destroyConsumer(Consumer con)
            throws BrokerException;

    public void connectionClosed(ConnectionUID uid, boolean admin);

    public void reloadCluster();

    /**
     * Ensures that the given "prefix" number is unique in the
     * cluster. This method is used to ensure the uniqueness of the
     * UIDs generated by a broker.
     *
     * @return true if the number is unique. false if some other
     * broker is using this number as a UID prefix.
     */
    public boolean lockUIDPrefix(short p);
}

