
/*
 * @(#)ClusterRouter.java	1.10 09/16/05
 *
 * Copyright 2005 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.core;

import java.util.*;
import java.io.*;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.jmsserver.core.*;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.multibroker.Protocol;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.io.*;


public interface ClusterRouter
{
    public void forwardMessage(PacketReference ref, Collection consumers);

    /* REPLACE THE NEXT SEVERAL PROTOCOL MESSAGES WITH handleCtrlMsg
     */

    public void addConsumer(Consumer c) 
       throws BrokerException, IOException, SelectorFormatException;

    public void removeConsumer(com.sun.messaging.jmq.jmsserver.core.ConsumerUID c)
       throws BrokerException, IOException;

    public void removeConsumers(ConnectionUID uid)
       throws BrokerException, IOException;

    public void brokerDown(com.sun.messaging.jmq.jmsserver.core.BrokerAddress ba)
       throws BrokerException, IOException;


    /*
     * END REPACEMENT
     */

    public void handleJMSMsg(Packet p, List consumers, BrokerAddress sender,
              boolean sendMsgRedeliver)
        throws BrokerException;


    /**
     * txnID must not be null for ack types
     *     MSG_TXN_ACKNOWLEDGED
     *     MSG_PREPARE
     *     MSG_ROLLEDBACK
     * These ack types are only sent by HA >= 4.0 brokers or 4.0 non-HA 
     * brokers with a special private property set
     *
     * txnID must be null for ack type
     *     MSG_ACKNOWLEDGED (transacted) if ack coming from < 4.0 broker
     *     or from a non-HA 4.0 broker/wo the special private property set                                
     *
     * txnID must not be null for ack type
     *     MSG_ACKNOWLEDGED (transacted) if ack coming from HA >= 4.0 broker
     *          or from a non-HA 4.0 broker/w a special private property set
     *
     * SysMessageID and ConsumerUID must not be null for ack type
     *     MSG_TXN_ACKNOWLEDGED
     *
     * SysMessageID and ConsumerUID must be null for ack types
     *     MSG_PREPARE
     *     MSG_ROLLEDBACK
     *
     * SysMessageID and ConsumerUID must not be null for ack type
     *     MSG_ACKNOWLEDGED (transacted) if txnID is null
     *
     * SysMessageID and ConsumerUID must be null for ack type
     *     MSG_ACKNOWLEDGED (transacted) if txnID is not null
     *
     * msgBrokerSession and msgStoreSession are passed in for all ack types
     *     msgBrokerSession null if the ack is from < 4.0 broker
     *     msgStoreSession  null if non-HA
     *
     */
    public void handleAck(int type, SysMessageID id, ConsumerUID uid, 
                          Map optionalProps, Long txnID, 
                          UID msgBrokerSession, UID msgStoreSession) 
                          throws BrokerException;

    public void handleCtrlMsg(int type, HashMap props)
        throws BrokerException;

}
