/*
 * @(#)DestinationUID.java	1.14 08/23/05
 *
 * Copyright 2003 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 */

package com.sun.messaging.jmq.jmsserver.core;

import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.lists.WeakValueHashMap;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.Globals;
import java.util.Collections;
import java.util.Map;
import java.util.HashMap;


public class DestinationUID extends StringUID {

    static final long serialVersionUID = 3047167637056417589L;
    
    private static Map topics = Collections.synchronizedMap(new WeakValueHashMap("DestinationUID_topics"));
    private static Map queues = Collections.synchronizedMap(new WeakValueHashMap("DestinationUID_queues"));

    private boolean isQueue = false;
    private String name = null;

    private static String localQueue = 
          Globals.getBrokerResources().getString(
              BrokerResources.M_QUEUE);

    private static String localTopic =
          Globals.getBrokerResources().getString(
              BrokerResources.M_TOPIC);

    public static void clearCache() {
        queues.clear();
        topics.clear();
    }
        
    protected DestinationUID(String name, boolean queue) {
        super(getUniqueString(name,queue));
        this.name = name;
        this.isQueue = queue;
    }

    public DestinationUID(String str) {
        super(str);
        name = getName(str);
        isQueue = getIsQueue(str);
    }

    public String getDestType() {
        if (isQueue)
            return localQueue;
        return localTopic;
    }

    public String getLocalizedName() {
        return Globals.getBrokerResources().getString(
              BrokerResources.M_DESTINATION, name,
                getDestType());
    }


    private String getName(String str) {
        return str.substring(2);
    }
    private boolean getIsQueue(String str) {
        return str.charAt(0) == 'Q';
    }

    public String getName() {
        return name;
    }

    public boolean isQueue() {
        return isQueue;
    }

    public static DestinationUID getUID(String name, int type) {
        return getUID(name,DestType.isQueue(type));
    }


    public static DestinationUID getUID(String name, boolean isQueue) {
         
        DestinationUID duid = null;

        if (isQueue) {
            duid = (DestinationUID)queues.get(name);
            if (duid == null) {
                duid = new DestinationUID(name, isQueue);
                queues.put(name, duid);
            }
        } else {
            duid = (DestinationUID)topics.get(name);
            if (duid == null) {
                duid = new DestinationUID(name, isQueue);
                topics.put(name, duid);
            }
        }
        return duid;
    }

    public static void clearUID(DestinationUID uid) {
        if (uid.isQueue())
            queues.remove(uid.getName());
        else
            topics.remove(uid.getName());
    }

    public String toString() {
        return super.toString();
   }

    public String getLongString() {
        if (isQueue)
            return "queue:" + name;
        return "topic:" + name;
    }


    
    public static final String getUniqueString(String name, boolean isQueue) {
        StringBuffer buf = new StringBuffer();
        if (isQueue) {
            buf.append("Q:");
        } else {
            buf.append("T:");
        }
        buf.append(name);

        if (buf.indexOf("/") != -1) {
            for (int i=0; i < buf.length(); i ++) {
                char c = buf.charAt(i);
                if (c == '/') {
                   buf.setCharAt(i, '_');
                }
            }
        }
        return buf.toString();
    }

        
}
