/*
 * @(#)LowPriorityComparator.java	1.4 06/09/04
 *
 * Copyright 2000-2003 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */


package com.sun.messaging.jmq.jmsserver.core;

import java.util.Comparator;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;

class LowPriorityComparator implements Comparator
{
    public int compare(Object o1, Object o2) {
        if (o1 instanceof PacketReference && o2 instanceof PacketReference) {
                PacketReference ref1 = (PacketReference) o1;
                PacketReference ref2 = (PacketReference) o2;

                if (ref1.equals(ref2))
                    return 0;

                // compare priority
                long dif = ref1.getPriority() - ref2.getPriority();

                if (dif == 0)
                    dif = ref1.getTimestamp() - ref2.getTimestamp();

                // then sequence
                if (dif == 0)
                    dif = ref1.getSequence() - ref2.getSequence();

                if (dif == 0)
                    dif = ref1.getCreateTime() - ref2.getCreateTime();

                if (dif < 0) return -1;
                if (dif > 0) return 1;
                return o1.hashCode() - o2.hashCode();
        } else {
            assert false;
            return o1.hashCode() - o2.hashCode();
        }
    }
    public boolean equals(Object o) {
        return super.equals(o);
    }
    public int hashCode() {
        return super.hashCode();
    }
    
}
