/*
 * @(#)Producer.java	1.25 01/23/06
 *
 * Copyright 2003 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.core;

import java.util.*;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.service.*;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.util.CacheHashMap;
import com.sun.messaging.jmq.util.log.*;
import com.sun.messaging.jmq.jmsserver.management.agent.Agent;

/**
 *
 */

//XXX - it would be nice to add metrics info
// unfortunately we dont know what producer a message
// comes from at this time
public class Producer {
    
    public static boolean DEBUG=false;

    private transient Logger logger = Globals.getLogger();

    // record information about the last 20 removed
    // producers
    private static CacheHashMap cache = new CacheHashMap(20);

    private boolean valid = true;
    
    private static Map allProducers = Collections.synchronizedMap(
                    new HashMap());

    private ConnectionUID connection_uid;
    
    private DestinationUID destination_uid;
    private ProducerUID uid;
    
    private long creationTime;

    private int pauseCnt = 0;
    private int resumeCnt = 0;
    private int msgCnt = 0;
    transient SysMessageID creator = null;

    public String toString() {
        return "Producer["+ uid + "," + destination_uid + "," +
               connection_uid + "]";
    }
    
    public static Hashtable getAllDebugState() {
        Hashtable ht = new Hashtable();
        ht.put("TABLE", "AllProducers");
        Vector v = new Vector();
        synchronized (cache) {
            Iterator itr = cache.keySet().iterator();
            while (itr.hasNext()) {
                v.add(String.valueOf(((ProducerUID)itr.next()).longValue()));
            }
            
        }
        ht.put("cache", v);
        HashMap tmp = null;
        synchronized(allProducers) {
            tmp = new HashMap(allProducers);
        }
        Hashtable producers = new Hashtable();
        Iterator itr = tmp.keySet().iterator();
        while(itr.hasNext()) {
            ProducerUID p = (ProducerUID)itr.next();
            Producer producer = (Producer)tmp.get(p);
            producers.put(String.valueOf(p.longValue()),
                  producer.getDebugState());
        }
        ht.put("producersCnt", new Integer(allProducers.size()));
        ht.put("producers", producers);
        return ht;
            
    }

    public synchronized void pause() {
        pauseCnt ++;
    }

    public synchronized void addMsg()
    {
        msgCnt ++;
    }

    public synchronized int getMsgCnt()
    {
        return msgCnt;
    }
    public synchronized boolean isPaused()
    {
        return pauseCnt > resumeCnt;
    }

    public synchronized void resume() { 
        resumeCnt ++;
    }

    public Hashtable getDebugState() {
        Hashtable ht = new Hashtable();
        ht.put("TABLE", "Producer["+uid.longValue()+"]");
        ht.put("uid", String.valueOf(uid.longValue()));
        ht.put("valid", String.valueOf(valid));
        ht.put("pauseCnt", String.valueOf(pauseCnt));
        ht.put("resumeCnt", String.valueOf(resumeCnt));
        if (connection_uid != null)
            ht.put("connectionUID", String.valueOf(connection_uid.longValue()));
        if (destination_uid != null)
            ht.put("destination", destination_uid.toString());
        return ht;
    }

    /** Creates a new instance of Producer */
    private Producer(ConnectionUID cuid, DestinationUID duid) {
        uid = new ProducerUID();
        this.connection_uid = cuid;
        this.destination_uid = duid;
        logger.log(Logger.DEBUG,"Creating new Producer " + uid + " on "
             + duid + " for connection " + cuid);
    }
   
    public ProducerUID getProducerUID() {
        return uid;
    } 

    public ConnectionUID getConnectionUID() {
        return connection_uid;
    }
    public DestinationUID getDestinationUID() {
        return destination_uid;
    }

    public static void clearProducers() {
        cache.clear();
        allProducers.clear();
    }

    public static String checkProducer(ProducerUID uid)
    {
        String str = null;

        synchronized (cache) {
            str = (String)cache.get(uid);
        }
        if (str == null) {
             return " pid " + uid + " not of of last 20 removed";
        }
        return "Producer[" +uid + "]:" + str;
    }

    public static void updateProducerInfo(ProducerUID uid, String str)
    {
        synchronized (cache) {
            cache.put(uid, System.currentTimeMillis() + ":" + str);
        }
    }

    public static Iterator getAllProducers() {
        return (new ArrayList(allProducers.values())).iterator();
    }

    public static int getNumProducers() {
        return (allProducers.size());
    }

    public static Producer getProducer(ProducerUID uid) {
        return (Producer)allProducers.get(uid);
    }

    public static Producer destroyProducer(ProducerUID uid, String info) {
        Producer p = (Producer)allProducers.remove(uid);
        updateProducerInfo(uid, info);
        if (p == null) {
            return p;
        }
        Destination d = Destination.getDestination(p.getDestinationUID());
        if (d != null) {
           d.removeProducer(uid);
        }
        p.destroy();
        return p;
    }

    

    public static Producer createProducer(DestinationUID duid,
              ConnectionUID cuid, SysMessageID id) 
    {
        Producer producer = new Producer(cuid, duid);
        Object old = allProducers.put(producer.getProducerUID(), producer);
        producer.creator = id;
        assert old == null : old;

        return producer;
    }

    public synchronized void destroy() {
        valid = false;
    }

    public synchronized boolean isValid() {
        return valid;
    }

    public static Producer getProducer(SysMessageID creator)
    {
        if (creator == null) return null;

        synchronized(allProducers) {
            Iterator itr = allProducers.values().iterator();
            while (itr.hasNext()) {
                Producer c = (Producer)itr.next();
                if (creator.equals(c.creator))
                    return c;
            }
        }
        return null;
    }

}
