/*
 * @(#)RemoteConsumer.java	1.4 05/03/05
 *
 * Copyright 2003 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.core.cluster;



/**
 * Class which handled 3.0 remove cluster topic
 * consumers (3.5 clusters will be smarter in
 * later releases
 */


import java.util.*;
import java.io.*;
import com.sun.messaging.jmq.util.selector.*;
import com.sun.messaging.jmq.util.log.*;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.*;
import com.sun.messaging.jmq.jmsserver.core.*;

public class RemoteConsumer extends Consumer
{
    transient Set consumers = new HashSet();

    public static boolean DEBUG = false;

    private static Logger logger = Globals.getLogger();

    public RemoteConsumer(DestinationUID duid) 
        throws IOException, SelectorFormatException
    {
        super(duid, null, false, (ConnectionUID)null);
    }

    public int getConsumerCount() {
        synchronized(consumers) {
            return consumers.size();
        }
    }

    public void addConsumer(Consumer c) 
    {
        synchronized(consumers) {
            consumers.add(c);
        }
    }

    public void removeConsumer(Consumer c)
    {
        synchronized(consumers) {
            consumers.remove(c);
        }
    }

    public boolean match(PacketReference msg, Set s)
         throws BrokerException, SelectorFormatException
    {
        boolean match = false;
        Map props = null;
        Map headers = null;
      
        synchronized(consumers) {
            Iterator itr = consumers.iterator();
            Consumer c = (Consumer) itr.next();
            if (c.getSelector() == null) {
                match = true;
                s.add(c);
             } else  {
                 Selector selector = c.getSelector();
        
                 if (props == null && selector.usesProperties()) {
                     try {
                         props = msg.getProperties();
                     } catch (ClassNotFoundException ex) {
                         logger.logStack(Logger.ERROR,"INTERNAL ERROR", ex);
                         props = new HashMap();
                     }
                 }
                 if (headers == null && selector.usesFields()) {
                     headers = msg.getHeaders();
                 }
                 if (selector.match(props, headers)) {
                     match = true;
                     s.add(c);
                 }
           
            }
            return match;
        }
    }

} 
