/*
 * @(#)ErrorHandler.java	1.11 01/15/03
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.data.handlers;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.util.log.*;
import com.sun.messaging.jmq.jmsserver.resources.*;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;



/**
 * Handler class which deals with handling error messages
 */
public class ErrorHandler extends PacketHandler 
{

    /**
     * Method to handle error messages
     */
    public boolean handle(IMQConnection con, Packet msg) 
        throws BrokerException
    {
         Exception ex = new Exception();
         ex.fillInStackTrace();
         Globals.getLogger().logStack(Logger.ERROR,BrokerResources.E_INTERNAL_BROKER_ERROR, "received unexpected error in handler ", ex);
         return true;
    }

}
