/*
 * @(#)FlowPausedHandler.java	1.5 06/10/03
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.data.handlers;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.util.log.*;
import java.io.IOException;
import com.sun.messaging.jmq.io.PacketType;
import com.sun.messaging.jmq.io.Status;
import com.sun.messaging.jmq.jmsserver.resources.*;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.service.ConnectionManager;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;

import java.util.*;



/**
 */
public class FlowPausedHandler extends PacketHandler 
{
    private Logger logger = Globals.getLogger();
    public FlowPausedHandler() {
    }

    /**
     * Method to handle FlowPaused messages
     */
    public boolean handle(IMQConnection con, Packet msg) 
        throws BrokerException
    {
        assert msg.getPacketType() == PacketType.FLOW_PAUSED;
        Hashtable props = null;
        try {
            props = msg.getProperties();
        } catch (Exception ex) {
            logger.logStack(Logger.ERROR,
                  Globals.getBrokerResources().getString(
                      BrokerResources.X_INTERNAL_EXCEPTION,
                      "FlowPaused"
                     ), ex);
            assert false : ex;
        }

        Long size_var = (props != null ?(Long)props.get("JMQSize") : null);
        long size = (size_var == null ? 0 : size_var.longValue());

        con.flowPaused(size);

        // client doesnt sent this message at this time

        assert false : "Unsupported - XXX " + msg;


        return true;
    }

}
