/*
 * @(#)AdminCmdHandler.java	1.22 05/19/05
 *
 * Copyright 2000-2004 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import java.util.Hashtable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ByteArrayOutputStream;
import java.net.InetAddress;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.resources.*;
import com.sun.messaging.jmq.io.*;
import com.sun.messaging.jmq.util.admin.MessageType;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;

public class AdminCmdHandler
{
    AdminDataHandler parent = null;
    public static boolean DEBUG = false;
    protected Logger logger = Globals.getLogger();
    protected BrokerConfig props = Globals.getConfig();
    protected BrokerResources rb = Globals.getBrokerResources();

    public AdminCmdHandler() {
    }

    public AdminCmdHandler(AdminDataHandler parent) {
	this.parent = parent;
    }

    /**
     * Default handler. Just replies to the message with the
     * correct reply message type and a status of "Not Implemented"
     */
    public boolean handle(IMQConnection con, Packet cmd_msg,
				       Hashtable cmd_props) {

	Integer n = (Integer)cmd_props.get(MessageType.JMQ_MESSAGE_TYPE);

	Packet reply = new Packet(con.useDirectBuffers());
	reply.setPacketType(PacketType.OBJECT_MESSAGE);

	// By convention reply message is the message type + 1
	setProperties(reply, n.intValue() + 1, Status.ERROR, "Not Implemented");

	parent.sendReply(con, cmd_msg, reply);
        return true;
    }

    public static void setProperties(Packet pkt,
        int message_type, int status, String error_string) {
        setProperties(pkt, message_type, status,
             error_string, null);
    }

    public static void setProperties(Packet pkt,
        int message_type, int status, String error_string,
         Hashtable addprops) {

	Hashtable props = null;
        if (addprops != null) {
            props =new Hashtable(addprops);
        } else {
            props =new Hashtable();
        }

	props.put(MessageType.JMQ_MESSAGE_TYPE, new Integer(message_type));
	props.put(MessageType.JMQ_STATUS, new Integer(status));
	if (error_string != null) {
	    props.put(MessageType.JMQ_ERROR_STRING, error_string);
	}
	pkt.setProperties(props);
    }

    /**
     * Get object from the body of a packet
     */
    protected Object getBodyObject(Packet pkt) {

	ObjectInputStream ois;
	Object o = null;

	// Extract the object from the message body
	try {
	    ois = new ObjectInputStream(pkt.getMessageBodyStream());
	    o = ois.readObject();
        } catch (Exception e) {
	    // Programing error. Do not need to localize
	    logger.log(Logger.ERROR, rb.E_INTERNAL_BROKER_ERROR,
                this.getClass().getName() +
	        " : Got exception reading body of administration message:\n" +
		e + "\n" +
		pkt.dumpPacketString());
	}

	return o;
    }

    /**
     * Set an object into the body of a packet
     */
    protected void setBodyObject(Packet pkt, Object o) {

	ByteArrayOutputStream bos = new ByteArrayOutputStream();
	try {
	    ObjectOutputStream oos = new ObjectOutputStream(bos);
	    oos.writeObject(o);
	    oos.close();
	    pkt.setMessageBody(bos.toByteArray());
	} catch (Exception e) {
	    // Programing error. Do not need to localize
	    logger.log(Logger.ERROR, rb.E_INTERNAL_BROKER_ERROR,
	        this.getClass().getName() +
	        " : Got exception writing Vector to admin reply message:\n" +
		e + "\n" + o.toString());
	}
    }

    /**
     * Get a message from an Exception. This basically checks
     * if the exception is a BrokerException and properly formats
     * the linked exceptions message. The string returned does
     * NOT include the exception name.
     */
    public static String getMessageFromException(Exception e) {

	String m = e.getMessage();

	if (e instanceof BrokerException) {
            Throwable root_ex = ((BrokerException)e).getCause();
            if (root_ex == null) return m; // no root cause
	    String lm = root_ex.getMessage();

	    if (lm != null) {
	        m = m + "\n" + lm;
            }
	}
        return m;
    }

    public void waitForHandlersToComplete(int secs)
    {
        parent.waitForHandlersToComplete(secs);
    }
}
