/*
 * @(#)GetDestinationsHandler.java	1.36 08/10/05
 *
 * Copyright 2000-2005 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import java.util.Hashtable;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Vector;
import java.util.Iterator;
import java.util.List;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.data.PacketRouter;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.SizeString;
import com.sun.messaging.jmq.io.*;
import com.sun.messaging.jmq.util.admin.MessageType;
import com.sun.messaging.jmq.util.admin.ConnectionInfo;
import com.sun.messaging.jmq.util.admin.DestinationInfo;
import com.sun.messaging.jmq.util.admin.ConsumerInfo;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Destination;

public class GetDestinationsHandler extends AdminCmdHandler
{
    public GetDestinationsHandler(AdminDataHandler parent) {
    super(parent);
    }

    /**
     * Handle the incomming administration message.
     *
     * @param con    The Connection the message came in on.
     * @param cmd_msg    The administration message
     * @param cmd_props The properties from the administration message
     */
    public boolean handle(IMQConnection con, Packet cmd_msg,
                       Hashtable cmd_props) {

        if ( DEBUG ) {
            logger.log(Logger.DEBUG, this.getClass().getName() + ": " +
                            "Getting destinations: " + cmd_props);
        }


        Vector v = new Vector();
        int status = Status.OK;
        String errMsg = null;

        String destination = (String)cmd_props.get(MessageType.JMQ_DESTINATION);
        Integer destType = (Integer)cmd_props.get(MessageType.JMQ_DEST_TYPE);

        assert destination == null || destType != null;

        if (destination != null) {
            try {
                Destination d= Destination.getDestination(destination,
                          DestType.isQueue(destType.intValue()));

                if (d != null) {
                    if (DEBUG) {
                        d.debug();
                    }

                    v.add(getDestinationInfo(d));
                } else {
                    errMsg= rb.getString( rb.X_DESTINATION_NOT_FOUND, 
                               destination);
                    status = Status.NOT_FOUND;
                }
            } catch (Exception ex) {
                logger.log(Logger.ERROR,"Internal Error ", ex);
                assert false;
            }
        } else {
                // Get info on ALL destinations
    
           Iterator itr = Destination.getAllDestinations();
     
           while (itr.hasNext()) {
               Destination d = (Destination)itr.next();
               DestinationInfo dd= getDestinationInfo(d);
               v.add(dd);
           } 
       }

       // Send reply
       Packet reply = new Packet(con.useDirectBuffers());
       reply.setPacketType(PacketType.OBJECT_MESSAGE);
   
       setProperties(reply, MessageType.GET_DESTINATIONS_REPLY,
           status, errMsg);
   
       setBodyObject(reply, v);
       parent.sendReply(con, cmd_msg, reply);

       return true;
   }


    public static DestinationInfo getDestinationInfo(Destination d) {
        DestinationInfo di = new DestinationInfo();
        di.nMessages=d.size();
        di.nMessageBytes=d.byteSize();
        di.nConsumers=d.getConsumerCount();
        di.nfConsumers=d.getFailoverConsumerCount();
        di.naConsumers=d.getActiveConsumerCount();
        di.nProducers= d.getProducerCount();
        di.autocreated=(d.isAutoCreated() || d.isInternal() || d.isDMQ()
                        || d.isAdmin());
        di.destState=d.getState();
        di.name=d.getDestinationName();
        di.type=d.getType() &
                ~(DestType.DEST_INTERNAL | DestType.DEST_AUTO | DestType.DEST_ADMIN);

        di.fulltype=d.getType();
        di.maxMessages=d.getCapacity();
        if (di.maxMessages < 0)
            di.maxMessages = 0;
        SizeString bc = d.getByteCapacity();
        di.maxMessageBytes=(bc == null ? 0 : bc.getBytes());
        if (di.maxMessageBytes < 0)
            di.maxMessageBytes = 0;
        bc = d.getMaxByteSize();
        di.maxMessageSize=(bc == null ? 0 : bc.getBytes());
        if (di.maxMessageSize < 0)
            di.maxMessageSize = 0;
        di.destScope=d.getScope();
        di.destLimitBehavior=d.getLimitBehavior();
        di.maxPrefetch=d.getMaxPrefetch();
        di.destCDP=d.getClusterDeliveryPolicy();
        di.maxActiveConsumers=d.getMaxActiveConsumers();
        di.maxFailoverConsumers=d.getMaxFailoverConsumers();
        di.maxProducers = d.getMaxProducers();
        di.maxNumSharedConsumers = d.getMaxNumSharedConsumers();
        di.sharedConsumerFlowLimit = d.getSharedConsumerFlowLimit();
        di.useDMQ = d.getUseDMQ();
        di.nUnackMessages = d.getUnackSize();
        di.nTxnMessages = d.txnSize();
        di.nTxnMessageBytes = d.txnByteSize();
 
        return di;
        
    }


}
