/*
 * @(#)HelloHandler.java	1.7 01/15/03
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import java.util.Hashtable;
import java.io.IOException;
import java.io.*;
import java.util.Vector;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.io.*;
import com.sun.messaging.jmq.util.admin.MessageType;
import com.sun.messaging.jmq.util.admin.ServiceInfo;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.jmsserver.Globals;

public class HelloHandler extends AdminCmdHandler
{
    public HelloHandler(AdminDataHandler parent) {
	super(parent);
    }

    public boolean handle(IMQConnection con, Packet cmd_msg,
				       Hashtable cmd_props) {

	if ( DEBUG ) {
            logger.log(Logger.DEBUG, this.getClass().getName() + ": " +
                "Got Hello: " + cmd_props);
        }

	Packet reply = new Packet(con.useDirectBuffers());
	reply.setPacketType(PacketType.OBJECT_MESSAGE);

	Hashtable props = new Hashtable();
	props.put(MessageType.JMQ_MESSAGE_TYPE,
		  new Integer(MessageType.HELLO_REPLY));

	props.put(MessageType.JMQ_INSTANCE_NAME, Globals.getConfigName());
	props.put(MessageType.JMQ_STATUS, new Integer(Status.OK));
	reply.setProperties(props);

	parent.sendReply(con, cmd_msg, reply);
    return true;
    }
}
