/*
 * @(#)PurgeDurableHandler.java	1.6 04/08/03
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import java.util.Hashtable;
import java.io.IOException;
import java.io.*;
import java.util.Vector;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.io.*;
import com.sun.messaging.jmq.util.admin.MessageType;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.jmsserver.Globals;

public class PurgeDurableHandler extends AdminCmdHandler
{
    public PurgeDurableHandler(AdminDataHandler parent) {
	super(parent);
    }

    /**
     * Handle the incomming administration message.
     *
     * @param con	The Connection the message came in on.
     * @param cmd_msg	The administration message
     * @param cmd_props The properties from the administration message
     */
    public boolean handle(IMQConnection con, Packet cmd_msg,
				       Hashtable cmd_props) {

	if ( DEBUG ) {
            logger.log(Logger.DEBUG, this.getClass().getName() + ": " +
                "PurgeDurable: " + cmd_props);
        }

	String durable = (String)cmd_props.get(MessageType.JMQ_DURABLE_NAME);
	String clientID = (String)cmd_props.get(MessageType.JMQ_CLIENT_ID);

	// Send reply
        int status = Status.OK;
        String errMsg = null;

        try {
            Subscription sub = Subscription.findDurableSubscription(clientID, durable);
            if (sub == null) {
                // couldnt find subscription
//XXX
                errMsg = " unknown durable subscription " + durable + ":" + clientID; 
                status = Status.ERROR;
            } else {
                sub.purge();
            }
          
        } catch (BrokerException ex) {
            ex.printStackTrace();
            errMsg = getMessageFromException(ex);
            status = Status.ERROR;
        }

	Packet reply = new Packet(con.useDirectBuffers());
	reply.setPacketType(PacketType.OBJECT_MESSAGE);

	setProperties(reply, MessageType.PURGE_DURABLE_REPLY,
		status, errMsg);
	parent.sendReply(con, cmd_msg, reply);
        return true;
    }
}
