/*
 * @(#)UpdateBrokerPropsHandler.java	1.8 01/15/03
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import java.util.Hashtable;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Vector;
import java.util.Properties;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.io.*;
import com.sun.messaging.jmq.util.admin.MessageType;
import com.sun.messaging.jmq.util.admin.BrokerInfo;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.*;

public class UpdateBrokerPropsHandler extends AdminCmdHandler
{
    public UpdateBrokerPropsHandler(AdminDataHandler parent) {
	super(parent);
    }

    /**
     * Handle the incomming administration message.
     *
     * @param con	The Connection the message came in on.
     * @param cmd_msg	The administration message
     * @param cmd_props The properties from the administration message
     */
    public boolean handle(IMQConnection con, Packet cmd_msg,
				       Hashtable cmd_props) {

        int status = Status.OK;
        String msg = null;

	if ( DEBUG ) {
            logger.log(Logger.DEBUG, this.getClass().getName() + ": " +
                cmd_props);
        }

        // Get properties we are to update from message body
	Properties p = (Properties)getBodyObject(cmd_msg);

        // Update the broker configuration
	BrokerConfig bcfg = Globals.getConfig();
	try {
            bcfg.updateProperties(p, true);
	} catch (PropertyUpdateException e) {
            status = Status.BAD_REQUEST;
            msg = e.getMessage();
            logger.log(Logger.WARNING, msg);
	} catch (IOException e) {
            status = Status.ERROR;
            msg = e.toString();
            logger.log(Logger.WARNING, msg);
	}

	// Send reply
	Packet reply = new Packet(con.useDirectBuffers());
	reply.setPacketType(PacketType.OBJECT_MESSAGE);

	setProperties(reply, MessageType.UPDATE_BROKER_PROPS_REPLY,
		status, msg);

	parent.sendReply(con, cmd_msg, reply);
    return true;
    }
}
