/*
 * @(#)UpdateDestinationHandler.java	1.21 05/28/04
 *
 * Copyright 2000-2004 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import java.util.Hashtable;
import java.io.IOException;
import java.io.*;
import java.util.Vector;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.io.*;
import com.sun.messaging.jmq.util.admin.MessageType;
import com.sun.messaging.jmq.util.admin.DestinationInfo;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.util.SizeString;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.jmsserver.core.Destination;

public class UpdateDestinationHandler extends AdminCmdHandler
{
    public UpdateDestinationHandler(AdminDataHandler parent) {
	super(parent);
    }

    /**
     * Handle the incomming administration message.
     *
     * @param con	The Connection the message came in on.
     * @param cmd_msg	The administration message
     * @param cmd_props The properties from the administration message
     */
    public boolean handle(IMQConnection con, Packet cmd_msg,
				       Hashtable cmd_props) {

	if ( DEBUG ) {
            logger.log(Logger.DEBUG, this.getClass().getName() + ": " +
                cmd_props);
        }

	String destination = (String)cmd_props.get(MessageType.JMQ_DESTINATION);

	DestinationInfo info = (DestinationInfo)getBodyObject(cmd_msg);

    int status = Status.OK;
    String errMsg = null;

    try {
        Destination d= Destination.getDestination(info.name, 
            DestType.isQueue(info.type));
	if (d == null)  {
	   errMsg= rb.getString( rb.X_DESTINATION_NOT_FOUND,
					  info.name);
	   status = Status.NOT_FOUND;
	} else  {
            if (info.isModified(info.MAX_MESSAGES)) {
                int maxMessages = info.maxMessages;
                d.setCapacity(maxMessages);
            }
            if (info.isModified(info.MAX_MESSAGE_SIZE)) {
                SizeString maxSize = new SizeString();
                maxSize.setBytes(info.maxMessageSize);
                d.setMaxByteSize(maxSize);
            }
            if (info.isModified(info.MAX_MESSAGE_BYTES)) {
                SizeString maxBytes = new SizeString();
                maxBytes.setBytes(info.maxMessageBytes);
                d.setByteCapacity(maxBytes);
            }
            if (info.isModified(info.DEST_SCOPE)) {
                int scope = info.destScope;
                d.setScope(scope);
            
            }
            if (info.isModified(info.DEST_LIMIT)) {
                int destlimit = info.destLimitBehavior;
                d.setLimitBehavior(destlimit);
            }
            if (info.isModified(info.DEST_PREFETCH)) {
                int prefetch = info.maxPrefetch;
                d.setMaxPrefetch(prefetch);
            }
            if (info.isModified(info.DEST_CDP)) {
                int clusterdeliverypolicy = info.destCDP;
                d.setClusterDeliveryPolicy(clusterdeliverypolicy);
            }
            if (info.isModified(info.MAX_ACTIVE_CONSUMERS)) {
                int maxcons = info.maxActiveConsumers;
                d.setMaxActiveConsumers(maxcons);
            }
            if (info.isModified(info.MAX_FAILOVER_CONSUMERS)) {
                int maxcons = info.maxFailoverConsumers;
                d.setMaxFailoverConsumers(maxcons);
            }
            if (info.isModified(info.MAX_PRODUCERS)) {
                int maxproducers = info.maxProducers;
                d.setMaxProducers(maxproducers);
            }
            if (info.isModified(info.MAX_SHARED_CONSUMERS)) {
                int maxsharedcons = info.maxNumSharedConsumers;
                d.setMaxSharedConsumers(maxsharedcons);
            }
            if (info.isModified(info.SHARE_FLOW_LIMIT)) {
                int sflowlimit = info.sharedConsumerFlowLimit;
                d.setSharedFlowLimit(sflowlimit);
            }
            if (info.isModified(info.USE_DMQ)) {
                boolean dmq = info.useDMQ;
                d.setUseDMQ(dmq);
            }
            d.update();
	}
        
    } catch (Exception ex) {
        errMsg = getMessageFromException(ex);
        status = Status.ERROR;
    }


	// Send reply
	Packet reply = new Packet(con.useDirectBuffers());
	reply.setPacketType(PacketType.OBJECT_MESSAGE);

	setProperties(reply,
	    MessageType.UPDATE_DESTINATION_REPLY, status, errMsg);

	parent.sendReply(con, cmd_msg, reply);
    return true;
    }
}
