/*
 * @(#)LicenseBase.java	1.4 04/10/02
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */
package com.sun.messaging.jmq.jmsserver.license;

import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.resources.*;
import com.sun.messaging.jmq.util.log.Logger;

import java.io.*;
import java.util.*;
import java.security.*;

/**
 * iMQ broker license base class.
 */
public class LicenseBase {
    //
    // BEGIN core licence attributes and constants.
    //

    /** License attributes. */
    protected Properties props = new Properties();

    // Following attributes are derived from PROP_DATE_STRING.
    private int daysToTry = 0;
    private Date expirationDate = null; // expiration date
    private Date startDate = null; // start date of valid date range

    //////// License attribute property names ////////
    public static final String PROP_FILE_VERSION = "imq.file_version";
    public static final String PROP_LICENSE_VERSION = "imq.license_version";
    public static final String PROP_LICENSE_TYPE = "imq.license_type";
    public static final String PROP_DATE_STRING = "date_string";
    public static final String PROP_PRECEDENCE = "imq.precedence";
    public static final String PROP_DESCRIPTION = "description";

    //////// Expiration date string constants ////////
    protected static final String NONE_STRING = "NONE";
    protected static final String TRY_STRING = "TRY";
    protected static final String VALID_STRING = "VALID";
    protected static final String OPEN_BRACKET = "[";
    protected static final String CLOSE_BRACKET = "]";
    protected static final String DASH = "-";

    //////// Other (feature specific) license attributes ////////
    public static final String PROP_CLIENT_CONNLIMIT = "imq.max_client_conns";
    public static final String PROP_BROKER_CONNLIMIT = "imq.max_broker_conns";
    public static final String PROP_MAX_BACKUP_CONS = "imq.max_backup_cons";
    public static final String PROP_MAX_ACTIVE_CONS = "imq.max_active_cons";

    //////// Feature licensing ////////
    public static final String PROP_ENABLE_CLUSTER =
        "imq.enable_cluster";
    public static final String PROP_ENABLE_HTTP =
        "imq.enable_http";
    public static final String PROP_ENABLE_SSL =
        "imq.enable_ssl";
    public static final String PROP_ENABLE_FAILOVERQ =
        "imq.enable_failoverq";
    public static final String PROP_ENABLE_RRQ =
        "imq.enable_rrq";
    public static final String PROP_ENABLE_SHAREDPOOL =
        "imq.enable_sharedpool";
    public static final String PROP_ENABLE_C_API =
        "imq.enable_c_api";
    public static final String PROP_ENABLE_FAILOVER =
        "imq.enable_failover";
    public static final String PROP_ENABLE_MONITORING =
        "imq.enable_monitoring";
    public static final String PROP_ENABLE_LOCALDEST =
        "imq.enable_localdest";


    //
    // END licence attributes and constants.
    //

    protected static BrokerResources br = Globals.getBrokerResources();
    protected static Logger logger = Globals.getLogger();

    //
    // License information public access methods.
    //

    /**
     * Get any license attribute.
     */
    public String getProperty(String name) {
        return props.getProperty(name);
    }

    /**
     * Get an integer property.
     */
    public int getIntProperty(String name, int defval) {
        try {
            return Integer.parseInt(getProperty(name));
        }
        catch (Exception e) {
            return defval;
        }
    }

    /**
     * Get a boolean property.
     */
    public boolean getBooleanProperty(String name, boolean defval) {
        try {
            return Boolean.valueOf(getProperty(name)).booleanValue();
        }
        catch (Exception e) {
            return defval;
        }
    }

    /**
     * Get all the license properties.
     */
    public Properties getProperties() {
        return props;
    }

    public int getPrecedence() {
        int ret = 0;
        try {
            ret = Integer.parseInt(props.getProperty(PROP_PRECEDENCE));
        }
        catch (Exception e) {}
        return ret;
    }

    /**
     * Does this license expire.
     */
    public boolean willExpire() {
        String dateString = props.getProperty(PROP_DATE_STRING);
        if (dateString == null || ! dateString.equals(NONE_STRING))
            return true;

        return false;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date d) {
        startDate = d;
    }

    public Date getExpirationDate() {
        return expirationDate;
    }

    public void setExpirationDate(Date d) {
        expirationDate = d;
    }

    public int getDaysToTry() {
        return daysToTry;
    }

    public void setDaysToTry(int d) {
        daysToTry = d;
    }

    /**
     * This method is implemented by the subclasses of LicenseBase.
     * It tells the LicenseManager whether to raise an exception if
     * there are no license files.
     */
    public boolean isLicenseFileRequired() {
        return true;
    }
}

/*
 * EOF
 */
