/*
 * @(#)MQJMXAuthenticator.java	1.5 11/23/05
 *
 * Copyright 2005 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.management.agent;

import javax.security.auth.Subject;
import javax.management.remote.JMXAuthenticator;

import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.MQAuthenticator;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;

/**
 * Authenticator for MQ JMX clients
 *
 */
public class MQJMXAuthenticator implements JMXAuthenticator {
    private Logger logger = Globals.getLogger();
    private ConnectorServerInfo csi;
    private BrokerResources rb = Globals.getBrokerResources();
    private MQAuthenticator a = null;

    public MQJMXAuthenticator(ConnectorServerInfo csi, 
				MQAuthenticator authenticator)  {
	this.csi = csi;
	this.a = authenticator;
    }

    public Subject authenticate(Object credentials)  {
	if (credentials == null)  {
	    String errStr = rb.getString(rb.W_JMX_CONNECTOR_CREDENTIALS_NEEDED, csi.getName());
            logger.log(Logger.WARNING, errStr);
	    throw new SecurityException(errStr);
	}

	if (!(credentials instanceof String[])) {
	    String errStr = rb.getString(rb.W_JMX_CONNECTOR_CREDENTIALS_WRONG_TYPE, csi.getName());
            logger.log(Logger.WARNING, errStr);
	    throw new SecurityException(errStr);
	}

	String[] up = (String[])credentials;
	String username = up[0], passwd = up[1];

	if (a != null)  {
	    try  {
	        a.authenticate(username, passwd);
	    } catch(Exception e)  {
	        String errStr 
		    = rb.getString(rb.W_JMX_CONNECTOR_AUTH_FAILED, csi.getName(), e.toString());
                logger.log(Logger.WARNING, errStr);
	        throw new SecurityException(errStr);
	    }
	}

	return new Subject();
    }
}
