/*
 * @(#)Protocol.java	1.11 08/30/05
 *
 * Copyright 2003 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.multibroker;

import java.io.*;
import java.util.*;
import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.core.*;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;

public interface Protocol extends ClusterCallback
{
    /**
     * Get the cluster protocol version used by this
     * protocol implementation.
     */
    public int getClusterVersion();

    /**
     * sets the list of properties that must match for brokers to connect
     */
    public void setMatchProps(Properties matchProps);

    public void startClusterIO();

    public void stopClusterIO(boolean requestTakeover);

    public void reloadCluster();

    public void stopMessageFlow() throws IOException;

    public void resumeMessageFlow() throws IOException;

    public boolean waitForConfigSync();

    public void sendMessage(PacketReference pkt, Collection targets,
                            boolean sendMsgDeliveredAck);

    public void sendMessageAck(com.sun.messaging.jmq.jmsserver.core.BrokerAddress msgHome, 
                               SysMessageID mid,
                               com.sun.messaging.jmq.jmsserver.core.ConsumerUID cid,
                               int ackType, boolean ackack, Map optionalProps, Long txnID) 
                               throws BrokerException;

    public void clientClosed(ConnectionUID conid, boolean notify);

    /**
     * Obtain a cluster-wide "shared" lock on a resource.
     * Unlike the normal "exclusive" locks, the shared locks allow
     * more than one clients to access the same resource. This method
     * ensures that the resource cannot be locked as shared and
     * exclusive at the same time!
     *
     * @param resID Resource name. The caller must ensure that
     * there are no name space conflicts between different
     * types of resources. This can be achieved by simply using
     * resource names like -"durable:foo", "queue:foo",
     * "clientid:foo"...
     * @param owner The ConnectionUID object representing the
     * client that will own this resource if this method returns
     * successfully. When this client goes away, the resource
     * will be unlocked automatically.
     * @return  ProtocolGlobals.G_LOCK_SUCCESS if the resource was
     *          locked successfully.
     *          ProtocolGlobals.G_LOCK_FAILURE if the resource could
     *          not be locked.
     */
    public int lockSharedResource(String resId, ConnectionUID owner);

    /**
     * Obtain a cluster-wide lock on a resource. This method is
     * used to ensure mutual exclusion for durable subscriptions,
     * queue receivers, client IDs etc.
     *
     * @param resID Resource name. The caller must ensure that
     * there are no name space conflicts between different
     * types of resources. This can be achieved by simply using
     * resource names like -"durable:foo", "queue:foo",
     * "clientid:foo"...
     *
     * @param timestamp The creation time for the resource.
     * In case of a lock contention the older resource automatically
     * wins.
     *
     * @param owner The ConnectionUID object representing the
     * client that will own this resource if this method returns
     * successfully. When this client goes away, the resource
     * will be unlocked automatically.
     *
     * @return MB_LOCK_SUCCESS if the resource was locked successfully.
     *         MB_LOCK_FAILURE if the resource could not be locked.
     */
    public int lockResource(String resId, long timestamp,
        ConnectionUID owner);

    /**
     * Unlocks a resource.
     */
    public void unlockResource(String resId);

    /**
     * Record the destination create / update event with the master
     * broker. This method must be called before the destination is
     * added. If it throws an exception, the error must be propagated
     * back to the client.
     */
    public void recordUpdateDestination(Destination d)
        throws BrokerException;

    /**
     * Record the destroy destination event with the master broker.
     * This method must be called before the destination is deleted.
     * If it throws an exception, the error must be propagated back to
     * the client.
     */
    public void recordRemoveDestination(Destination d)
        throws BrokerException;

    public void sendNewDestination(Destination d)
                  throws BrokerException;

    public void sendRemovedDestination(Destination d)
                  throws BrokerException;

    public void sendUpdateDestination(Destination d)
                  throws BrokerException;

    public void recordCreateSubscription(Subscription sub)
        throws BrokerException;

    public void recordUnsubscribe(Subscription sub)
        throws BrokerException;

    public void sendNewSubscription(Subscription sub, Consumer cons,
        boolean active) throws BrokerException;

    public void sendNewConsumer(Consumer intr, boolean active)
                  throws BrokerException;

    public void sendRemovedConsumer(Consumer intr)
                  throws BrokerException;

    public void handleGPacket(MessageBusCallback mbcb, 
        com.sun.messaging.jmq.jmsserver.core.BrokerAddress sender, GPacket pkt);
}
