/*
 * @(#)BrokerAddress.java	1.8 05/06/03
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.multibroker;

import java.io.*;

import com.sun.messaging.jmq.jmsserver.Globals;

/**
 * This class encapsulates the broker address / identifier. The
 * implementation is specific to the broker topology.
 */
public abstract class BrokerAddress implements Cloneable, Serializable {

    static final long serialVersionUID = -9113211699546934616L;


    /**
     * Writes the broker address to a given <code> DataOutputStream </code>.
     */
    public abstract void writeBrokerAddress(DataOutputStream dos)
        throws IOException;

    /**
     * Reads the broker address from a given <code> DataInputStream </code>
     */
    public abstract void readBrokerAddress(DataInputStream dis)
        throws IOException;

    public Object readResolve() throws ObjectStreamException {

        try {
            Object obj = null;
            obj = Globals.getMyAddress();
            return obj;
        } catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }

    } 


    public String toString() {
        return super.toString() + "@deprecated";
    }
}

/*
 * EOF
 */
