/*
 * @(#)Interest.java	1.6 08/17/04
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */


package com.sun.messaging.jmq.jmsserver.multibroker;

import java.io.*;
import java.util.*;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.Subscription;

/**
 * This class represents a client interest.
 * @deprecated since 3.5
 */
public class Interest implements  Serializable
{
    /*
     * Added serialVersionUID for compatibility with iMQ 2.0.
     *
     * Note - The JDK 1.3 compiler generates a different
     * serialVersionUID for this class than prior JDK versions.
     * This can lead to nasty interoperability / compatibility
     * problems. Until this issue is fully resolved by JDK folks,
     * we should stick to JDK 1.2 compiler.
     */
    public static final long serialVersionUID = 99353142765567461L;

    /**
     * Interest identifier that is unique across the cluster.
     */
    // auto converted
    protected com.sun.messaging.jmq.jmsserver.core.ConsumerUID id = null;

    /**
     * JMS durable name.
     */
    protected String durableName = null;

    /**
     * JMS client id.
     */
    protected String clientID = null;

    /**
     * Name of the destination.
     */
    protected String destName = null;

    /**
     * Optional selector string specified by the client application.
     */
    protected String selstr = null;

    /**
     * This flag is <code> true </code> if a durable subscription is
     * currently in 'attached' stated. It tells the broker whether
     * to forward a message to this interest right away or hold it
     * until somebody attaches to this durable subscription.
     */
    protected boolean consumerReady = true;

    /**
     * flag which determines if messages should be sent to interests
     * on the same connection.
     */
    protected boolean noLocalDelivery = false;

    /**
     * Is this a queue interest or topic interest.
     */
    protected boolean isQueue = false;


    /**
     * Address of the broker directly connected to the client.
     */
    private BrokerAddress brokerAddr;


    public Object readResolve() throws ObjectStreamException {

        try {
            DestinationUID duid = DestinationUID.getUID(destName,
                   isQueue);
            com.sun.messaging.jmq.jmsserver.core.Subscription 
                 obj = Subscription.subscribe(durableName,
                     clientID, selstr, duid,
                     noLocalDelivery, false, false);
            obj.setConsumerUID(id);
            Destination d = Destination.getDestination(duid);
            d.addConsumer(obj, true);
            Subscription.clearSubscriptions();            
            return obj;
        } catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }

    } 

}

/*
 * EOF
 */
