/*
 * @(#)GPacketHandler.java	1.3 05/19/05
 *
 * Copyright 2003 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.*;
import com.sun.messaging.jmq.jmsserver.util.*;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.multibroker.Cluster;
import com.sun.messaging.jmq.jmsserver.resources.*;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.util.log.*;
import com.sun.messaging.jmq.jmsserver.multibroker.*;

public abstract class GPacketHandler {
    protected RaptorProtocol p = null;

    protected Cluster c = null;
    protected BrokerAddress selfAddress = null;
    protected CallbackDispatcher cbDispatcher = null;

    protected Logger logger = Globals.getLogger();
    protected BrokerResources br = Globals.getBrokerResources();

    public GPacketHandler(RaptorProtocol p) {
        this.p = p;
        this.c = p.c;
        this.selfAddress = p.selfAddress;
        this.cbDispatcher = p.cbDispatcher;
    }

    public void handle(BrokerAddress sender, GPacket pkt) {
        logger.logStack(logger.ERROR, "Unexpected call", new Exception("Unexpected call"));
    }

    public void handle(MessageBusCallback cb, BrokerAddress sender, GPacket pkt) {
        logger.logStack(logger.ERROR, "Unexpected call", new Exception("Unexpected call"));
    }

}

/*
 * EOF
 */
