/*
 * @(#)ProtocolConsumerUIDIterator.java	1.2 05/20/05
 *
 * Copyright 2005 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import java.util.*;
import java.io.*;
import java.nio.*;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;

/**
 * A helper class to read list of ConsumerUIDs in cluster protocols
 */

public class ProtocolConsumerUIDIterator implements Iterator
{
    private int count = 0;
    private int count_read = 0;
    private DataInputStream dis = null;
    private BrokerAddress from = null;

    public ProtocolConsumerUIDIterator(byte[] payload, int count, BrokerAddress from) {
        ByteArrayInputStream bis = new ByteArrayInputStream(payload);
        dis = new DataInputStream(bis);
        this.count = count;
        this.count_read = 0;
        this.from = from;
    }

    public ProtocolConsumerUIDIterator(DataInputStream dis, int count) {
        this.dis = dis;
        this.count = count;
        this.count_read = 0;
    }

    public boolean hasNext() {
        if (count_read < 0) throw new IllegalStateException("ConsumerUIDIterator");  
        return count_read < count;
    }

    /**
     * Caller must catch RuntimeException and getCause
     */
    public Object next() throws RuntimeException {
        try {
        ConsumerUID cid =  ClusterConsumerInfo.readConsumerUID(dis);
        if (from != null) cid.setBrokerAddress(from);
        count_read++;
        return cid;
        } catch (IOException e) {
        count_read = -1;
        throw new RuntimeException(e);
        }
    }

    public void remove() {
        throw new UnsupportedOperationException("Not supported");
    }
}

