/*
 * @(#)ConfigChangeEventHandler.java	1.4 05/03/05
 *
 * Copyright 2003 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers;

import java.io.*;
import com.sun.messaging.jmq.util.*;
import com.sun.messaging.jmq.jmsserver.util.*;
import com.sun.messaging.jmq.io.*;
import com.sun.messaging.jmq.jmsserver.core.*;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.*;

public class ConfigChangeEventHandler extends GPacketHandler {
    public static boolean DEBUG = false;

    public ConfigChangeEventHandler(RaptorProtocol p) {
        super(p);
    }

    public void handle(BrokerAddress sender, GPacket pkt) {
        if (DEBUG)
            logger.log(logger.DEBUG, "ConfigChangeEventHandler");

        if (pkt.getType() == ProtocolGlobals.G_CONFIG_CHANGE_EVENT) {
            handleConfigChangeEvent(sender, pkt);
        }
        else if (pkt.getType() ==
            ProtocolGlobals.G_CONFIG_CHANGE_EVENT_REPLY) {
            handleConfigChangeEventReply(sender, pkt);
        }
        else {
            logger.log(logger.WARNING, "ConfigChangeEventHandler " +
                "Internal error : Cannot handle this packet :" +
                pkt.toLongString());
        }
    }

    public void handleConfigChangeEvent(BrokerAddress sender,
        GPacket pkt) {
        Long xidProp = (Long) pkt.getProp("X");
        p.receiveConfigChangeEvent(sender, xidProp,
            pkt.getPayload().array());
    }

    public void handleConfigChangeEventReply(BrokerAddress sender,
        GPacket pkt) {
	//	Bug ID 6252184 Escalation ID 1-8243878
	//
	//	Backported by Tom Ross tom.ross@sun.com
	//
	//	14 April 2005
	// old line below
	// long xid = ((Long) pkt.getProp("X")).longValue();
	// new line below
	Long xid = (Long) pkt.getProp("X");
        int status = ((Integer) pkt.getProp("S")).intValue();

        p.receiveConfigChangeEventReply(sender, xid, status);
    }
}


/*
 * EOF
 */
